/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

public class SgfApplication
implements TypedString {
    private final String name_;
    private final String version_;

    public static SgfApplication parse(String string) throws TypeParseException {
        if (string == null) {
            throw new TypeParseException();
        }
        return new SgfApplication(string);
    }

    public static SgfApplication create(String string, String string2) {
        ArgumentChecker.throwIfNull((Object)string, (Object)string2);
        return new SgfApplication(string, string2);
    }

    private SgfApplication(String string, String string2) {
        assert (string != null && string2 != null);
        this.name_ = string;
        this.version_ = string2;
    }

    private SgfApplication(String string) {
        assert (string != null);
        int n = string.indexOf(58);
        if (0 < n) {
            this.name_ = string.substring(0, n);
            this.version_ = string.substring(n + 1);
        } else {
            this.name_ = string;
            this.version_ = null;
        }
    }

    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return sgfId.equals(SgfId.APPLICATION);
    }

    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(this.name_);
        if (this.version_ != null) {
            stringBuilder.append(':').append(this.version_);
        }
        return stringBuilder.toString();
    }

    public String name() {
        return this.name_;
    }

    public String version() {
        return this.version_;
    }

    public int compareTo(Object object) {
        SgfApplication sgfApplication = (SgfApplication)object;
        return this.name_.compareTo(sgfApplication.name_);
    }
}

