/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;
import org.unitarou.util.ArgumentChecker;

public class SgfLine
implements TypedString {
    private static final Log log_s_ = LogFactory.getLog(SgfLine.class);
    private static final Pattern condition_s_ = Pattern.compile("([a-zA-Z]{2})\\s*:\\s*([a-zA-Z]{2})");
    private static final int START_POS = 1;
    private static final int END_POS = 2;
    private final SgfPoint start_;
    private final SgfPoint end_;

    public static SgfLine parse(SgfSize sgfSize, String string) throws TypeParseException {
        Matcher matcher = condition_s_.matcher(string);
        if (!matcher.matches()) {
            throw new TypeParseException("Bad argument value = " + string);
        }
        SgfLine sgfLine = new SgfLine(SgfPoint.parseMove(sgfSize, matcher.group(1)), SgfPoint.parseMove(sgfSize, matcher.group(2)));
        return sgfLine;
    }

    public static SgfLine parseQuietly(SgfSize sgfSize, String string) {
        try {
            return SgfLine.parse(sgfSize, string);
        }
        catch (TypeParseException typeParseException) {
            log_s_.debug("Parse failure: ", typeParseException);
            return null;
        }
    }

    public SgfLine(SgfPoint sgfPoint, SgfPoint sgfPoint2) {
        this.start_ = sgfPoint;
        this.end_ = sgfPoint2;
    }

    public SgfPoint getStart() {
        return this.start_;
    }

    public SgfPoint getEnd() {
        return this.end_;
    }

    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return ValueType.CPOINT.equals((Object)sgfId.valueType());
    }

    public String getString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.start_.getString());
        stringBuilder.append(':');
        stringBuilder.append(this.end_.getString());
        return stringBuilder.toString();
    }

    public boolean isValid(String string) {
        return string != null ? condition_s_.matcher(string).matches() : false;
    }

    public int compareTo(Object object) {
        SgfLine sgfLine = (SgfLine)object;
        return (this.start_.hashCode() - sgfLine.start_.hashCode()) * 52 * 53 + (this.end_.hashCode() - sgfLine.end_.hashCode());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SgfLine)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        SgfLine sgfLine = (SgfLine)object;
        return this.start_.equals(sgfLine.start_) && this.end_.equals(sgfLine.end_);
    }

    public int hashCode() {
        return this.start_.hashCode() * 52 * 53 + this.end_.hashCode();
    }
}

