/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SgfRectangle {
    private SgfPoint start_;
    private SgfPoint end_;

    public static SgfRectangle create(Collection<SgfPoint> collection) {
        SgfRectangle sgfRectangle = new SgfRectangle();
        for (SgfPoint sgfPoint : collection) {
            if (!sgfPoint.condition().equals((Object)SgfPointType.IN)) continue;
            sgfRectangle.intersect(sgfPoint);
        }
        return sgfRectangle;
    }

    public static SgfRectangle create(SgfPoint[] sgfPointArray) {
        SgfRectangle sgfRectangle = new SgfRectangle();
        for (SgfPoint sgfPoint : sgfPointArray) {
            if (!sgfPoint.condition().equals((Object)SgfPointType.IN)) continue;
            sgfRectangle.intersect(sgfPoint);
        }
        return sgfRectangle;
    }

    public static SgfRectangle[] createRegularRectangles(SgfPoint[] sgfPointArray) {
        return SgfRectangle.createRegularRectangles(Arrays.asList(sgfPointArray));
    }

    public static SgfRectangle[] createRegularRectangles(Collection<SgfPoint> collection) {
        ArrayList<SgfRectangle> arrayList = new ArrayList<SgfRectangle>();
        TreeSet<SgfPoint> treeSet = new TreeSet<SgfPoint>(collection);
        while (!treeSet.isEmpty()) {
            SgfPoint sgfPoint = (SgfPoint)treeSet.iterator().next();
            if (!sgfPoint.condition().equals((Object)SgfPointType.IN)) {
                treeSet.remove(sgfPoint);
                continue;
            }
            SgfRectangle sgfRectangle = SgfRectangle.findBestRectangle(treeSet, sgfPoint);
            arrayList.add(sgfRectangle);
            for (int i = sgfRectangle.getStart().x(); i <= sgfRectangle.getEnd().x(); ++i) {
                for (int j = sgfRectangle.getStart().y(); j <= sgfRectangle.getEnd().y(); ++j) {
                    treeSet.remove(SgfPoint.create(sgfPoint.size(), i, j));
                }
            }
        }
        return arrayList.toArray(new SgfRectangle[arrayList.size()]);
    }

    private static SgfRectangle findBestRectangle(Set<SgfPoint> set, SgfPoint sgfPoint) {
        Object object;
        int n;
        int n2;
        int n3;
        SgfPoint sgfPoint2;
        SgfPoint sgfPoint3;
        int n4 = sgfPoint.x();
        int n5 = sgfPoint.x() + 1;
        while (n5 <= sgfPoint.size().width() && set.contains(sgfPoint3 = SgfPoint.create(sgfPoint.size(), n5, sgfPoint.y()))) {
            n4 = n5++;
        }
        n5 = sgfPoint.y();
        int n6 = sgfPoint.y() + 1;
        while (n6 <= sgfPoint.size().height() && set.contains(sgfPoint2 = SgfPoint.create(sgfPoint.size(), sgfPoint.x(), n6))) {
            n5 = n6++;
        }
        int[] nArray = new int[n5 - sgfPoint.y() + 1];
        nArray[0] = n4 - sgfPoint.x() + 1;
        for (n3 = sgfPoint.y() + 1; n3 <= n5; ++n3) {
            n2 = sgfPoint.x();
            n = sgfPoint.x() + 1;
            while (n <= n4) {
                object = SgfPoint.create(sgfPoint.size(), n, n3);
                if (!set.contains(object)) {
                    n4 = n2;
                    break;
                }
                n2 = n++;
            }
            nArray[n3 - sgfPoint.y()] = (n3 - sgfPoint.y() + 1) * (n4 - sgfPoint.x() + 1);
        }
        n3 = 0;
        n2 = nArray[0];
        for (n = 1; n < nArray.length; ++n) {
            if (n2 >= nArray[n]) continue;
            n2 = nArray[n];
            n3 = n;
        }
        n = n2 / ++n3;
        object = new SgfRectangle();
        ((SgfRectangle)object).set(sgfPoint, SgfPoint.create(sgfPoint.size(), sgfPoint.x() + n - 1, sgfPoint.y() + n3 - 1));
        return object;
    }

    public SgfRectangle() {
        SgfSize sgfSize = SgfSize.create(52, 52);
        this.start_ = SgfPoint.create(sgfSize, sgfSize.width(), sgfSize.height());
        this.end_ = SgfPoint.create(sgfSize, 1, 1);
    }

    public SgfRectangle(SgfRectangle sgfRectangle) {
        ArgumentChecker.throwIfNull((Object)sgfRectangle);
        this.start_ = sgfRectangle.start_;
        this.end_ = sgfRectangle.end_;
    }

    public SgfRectangle(SgfSize sgfSize) {
        ArgumentChecker.throwIfNull((Object)sgfSize);
        this.start_ = SgfPoint.create(sgfSize, 1, 1);
        this.end_ = SgfPoint.create(sgfSize, sgfSize.width(), sgfSize.height());
    }

    public void set(SgfPoint sgfPoint, SgfPoint sgfPoint2) {
        ArgumentChecker.throwIfNull((Object)sgfPoint, (Object)sgfPoint2);
        if (!sgfPoint.size().equals(sgfPoint2.size())) {
            throw new IllegalArgumentException("Inconsistent size: start:" + sgfPoint.size() + ", end: " + sgfPoint2.size());
        }
        this.start_ = sgfPoint;
        this.end_ = sgfPoint2;
    }

    public void intersect(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        int n = Math.min(this.start_.x(), sgfPoint.x());
        int n2 = Math.min(this.start_.y(), sgfPoint.y());
        int n3 = Math.min(Math.max(this.end_.x(), sgfPoint.x()), sgfPoint.size().width());
        int n4 = Math.min(Math.max(this.end_.y(), sgfPoint.y()), sgfPoint.size().height());
        this.start_ = SgfPoint.create(sgfPoint.size(), n, n2);
        this.end_ = SgfPoint.create(sgfPoint.size(), n3, n4);
    }

    public void union(SgfRectangle sgfRectangle) {
        ArgumentChecker.throwIfNull((Object)sgfRectangle);
        int n = Math.min(Math.max(this.start_.x(), sgfRectangle.start_.x()), this.start_.size().width());
        int n2 = Math.min(Math.max(this.start_.y(), sgfRectangle.start_.y()), this.start_.size().height());
        int n3 = Math.min(this.end_.x(), sgfRectangle.end_.x());
        int n4 = Math.min(this.end_.y(), sgfRectangle.end_.y());
        this.start_ = SgfPoint.create(this.start_.size(), n, n2);
        this.end_ = SgfPoint.create(this.start_.size(), n3, n4);
    }

    public SgfPoint getStart() {
        return this.start_;
    }

    public SgfPoint getEnd() {
        return this.end_;
    }

    public int width() {
        return this.end_.x() - this.start_.x() + 1;
    }

    public int height() {
        return this.end_.y() - this.start_.y() + 1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        SgfRectangle sgfRectangle = (SgfRectangle)object;
        return this.start_.equals(sgfRectangle.start_) && this.end_.equals(sgfRectangle.end_);
    }

    public int hashCode() {
        return this.start_.hashCode() * 7 + this.end_.hashCode();
    }

    public String getValue() {
        if (this.end_.x() < this.start_.x() && this.end_.y() < this.start_.y()) {
            throw new IllegalArgumentException();
        }
        if (this.start_.equals(this.end_)) {
            return this.start_.getString();
        }
        return this.start_.getString() + ':' + this.end_.getString();
    }

    public String toString() {
        if (this.start_.equals(this.end_)) {
            return this.start_.getString();
        }
        return this.start_.getString() + ':' + this.end_.getString();
    }

    public boolean contains(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        return this.start_.x() <= sgfPoint.x() && this.start_.y() <= sgfPoint.y() && sgfPoint.x() <= this.end_.x() && sgfPoint.y() <= this.end_.y();
    }
}

