/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import java.util.EnumSet;
import org.unitarou.lang.Strings;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Filter;
import org.unitarou.util.FilterException;
import org.unitarou.util.NestedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertLineSeparatorFilter
extends NestedFilter<Collection> {
    private int maxLine_;
    private int currentLine_;
    private final EnumSet<Option> options_;

    public InsertLineSeparatorFilter() {
        this((Filter<Collection>)null);
    }

    public InsertLineSeparatorFilter(int n) {
        this(null, n);
    }

    public InsertLineSeparatorFilter(Filter<Collection> filter) {
        this(filter, 80);
    }

    public InsertLineSeparatorFilter(Filter<Collection> filter, int n) {
        super(filter);
        ArgumentChecker.throwIfNegative(n);
        this.options_ = EnumSet.noneOf(Option.class);
        this.maxLine_ = n;
        this.currentLine_ = 0;
    }

    public void setOption(EnumSet<Option> enumSet) {
        ArgumentChecker.throwIfNull(enumSet);
        this.options_.clear();
        this.options_.addAll(enumSet);
    }

    public EnumSet<Option> getOptions() {
        return this.options_.clone();
    }

    @Override
    public Collection filter(Collection collection) throws FilterException {
        collection = super.filter(collection);
        Collection collection2 = new Collection();
        for (RootGameTree rootGameTree : collection) {
            collection2.addLast(this.filterRootGameTreeFrame(rootGameTree));
        }
        return collection2;
    }

    private RootGameTree filterRootGameTreeFrame(RootGameTree rootGameTree) {
        RootGameTree rootGameTree2 = new RootGameTree(rootGameTree);
        rootGameTree2.setOpenUtr(this.insertLineSeparatorForUtr(rootGameTree2.getOpenUtr()));
        ++this.currentLine_;
        rootGameTree2.getSequence().clear();
        for (Node node : rootGameTree.getSequence()) {
            rootGameTree2.getSequence().addLast(this.filterNodeFrame(node));
        }
        rootGameTree2.clearGameTree();
        for (GameTree gameTree : rootGameTree.getChildren()) {
            rootGameTree2.addGameTree(this.filterGameTreeFrame(gameTree));
        }
        ++this.currentLine_;
        rootGameTree2.setCloseUtr(this.insertLineSeparatorForUtr(rootGameTree2.getCloseUtr()));
        return rootGameTree2;
    }

    private GameTree filterGameTreeFrame(GameTree gameTree) {
        GameTree gameTree2 = new GameTree(gameTree);
        gameTree2.setOpenUtr(this.insertLineSeparatorForUtr(gameTree2.getOpenUtr()));
        ++this.currentLine_;
        gameTree2.getSequence().clear();
        for (Node node : gameTree.getSequence()) {
            gameTree2.getSequence().addLast(this.filterNodeFrame(node));
        }
        gameTree2.clearGameTree();
        for (GameTree gameTree3 : gameTree.getChildren()) {
            gameTree2.addGameTree(this.filterGameTreeFrame(gameTree3));
        }
        ++this.currentLine_;
        gameTree2.setCloseUtr(this.insertLineSeparatorForUtr(gameTree2.getCloseUtr()));
        return gameTree2;
    }

    private Node filterNodeFrame(Node node) {
        Node node2 = new Node(node);
        node2.setOpenUtr(this.insertLineSeparatorForUtr(node2.getOpenUtr()));
        ++this.currentLine_;
        node2.clearProperty();
        for (Property property : node.getProperties()) {
            if (!(property = this.filterPropertyFrame(property)).isValid()) continue;
            node2.addProperty(property);
        }
        node2.setCloseUtr(this.insertLineSeparatorForUtr(node2.getCloseUtr()));
        return node2;
    }

    private Property filterPropertyFrame(Property property) {
        Property property2 = new Property(property);
        property2.setOpenUtr(this.insertLineSeparatorForUtr(property2.getOpenUtr()));
        this.updateString(property2.getEntireId());
        property2.clearValue();
        Value[] valueArray = property.getValues();
        boolean bl = this.usesSoftLineBreak(property2.sgfId().valueType());
        for (int i = 0; i < valueArray.length; ++i) {
            property2.addValue(this.filterValue(valueArray[i], i != 0, bl));
        }
        property2.setCloseUtr(this.insertLineSeparatorForUtr(property2.getCloseUtr()));
        return property2;
    }

    private boolean usesSoftLineBreak(ValueType valueType) {
        return valueType.equals((Object)ValueType.TEXT) && this.options_.contains((Object)Option.USE_SLB_FOR_TEXT) || valueType.equals((Object)ValueType.SIMPLE_TEXT) && this.options_.contains((Object)Option.USE_SLB_FOR_SIMPLETEXT);
    }

    private Value filterValue(Value value, boolean bl, boolean bl2) {
        String string = value.getString();
        String string2 = value.getOpenUtr();
        if (bl) {
            string2 = this.insertLineSeparatorForUtr(string2);
        } else {
            this.updateString(string2);
        }
        ++this.currentLine_;
        if (bl2) {
            string = this.insertLineSeparator(string, "\\" + Strings.LINE_SEPARATOR);
        } else {
            this.updateString(string);
        }
        ++this.currentLine_;
        return new Value(string, string2);
    }

    private void updateString(String string) {
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    this.currentLine_ = 0;
                    continue block3;
                }
                default: {
                    this.currentLine_ += c < '\u00ff' ? 1 : 2;
                }
            }
        }
    }

    private String insertLineSeparatorForUtr(String string) {
        return this.insertLineSeparator(string, Strings.LINE_SEPARATOR);
    }

    private String insertLineSeparator(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + (this.currentLine_ + string.length()) / this.maxLine_ * string2.length());
        if (this.maxLine_ <= this.currentLine_) {
            stringBuilder.append(string2);
            this.currentLine_ = 0;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuilder.append(c);
            switch (c) {
                case '\n': 
                case '\r': {
                    this.currentLine_ = 0;
                }
            }
            if (this.currentLine_ < this.maxLine_) {
                this.currentLine_ += c < '\u00ff' ? 1 : 2;
                continue;
            }
            stringBuilder.append(string2);
            this.currentLine_ = 0;
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        USE_SLB_FOR_TEXT,
        USE_SLB_FOR_SIMPLETEXT;


        public String toString() {
            return new Message(((Object)((Object)this)).getClass(), this.name()).get();
        }
    }
}

