/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import org.unitarou.lang.LogLevel;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.parser.SgfParserLogger;
import org.unitarou.util.Filter;
import org.unitarou.util.FilterException;
import org.unitarou.util.NestedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackRootPropertyFilter
extends NestedFilter<Collection> {
    private static final Message NT_MOVE_ROOT_PROPERTY = new Message(PackRootPropertyFilter.class, "ntMoveRootProperty");
    private SgfParserLogger logger_ = new SgfParserLogger();

    public PackRootPropertyFilter() {
    }

    public PackRootPropertyFilter(Filter<Collection> filter) {
        super(filter);
    }

    public SgfParserLogger getLogger() {
        return this.logger_;
    }

    public void setLogger(SgfParserLogger sgfParserLogger) {
        this.logger_ = sgfParserLogger;
    }

    @Override
    public Collection filter(Collection collection) throws FilterException {
        Collection collection2 = super.filter(collection);
        for (RootGameTree rootGameTree : collection2) {
            Sequence sequence = rootGameTree.getSequence();
            if (sequence.isEmpty()) continue;
            Node node = sequence.getFirst();
            this.filterImpl(node, rootGameTree);
        }
        return collection2;
    }

    private void filterImpl(Node node, GameTree gameTree) {
        for (Node node2 : gameTree.getSequence()) {
            if (node == node2) continue;
            for (Property property : node2.getProperties()) {
                if (!PropertyType.ROOT.equals(property.sgfId().propertyType())) continue;
                node2.removeProperty(property.sgfId());
                if (node.contains(property.sgfId())) continue;
                node.addProperty(property);
                this.logger_.log(LogLevel.INFO, 0, NT_MOVE_ROOT_PROPERTY.get((Object)property.sgfId().id()), "");
            }
        }
        for (GameTree gameTree2 : gameTree.getChildren()) {
            this.filterImpl(node, gameTree2);
        }
    }
}

