/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Filter;
import org.unitarou.util.FilterException;
import org.unitarou.util.NestedFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateVwFilter
extends NestedFilter<RootGameTree> {
    private static final SgfId[] STONES = new SgfId[]{SgfId.WHITE, SgfId.BLACK, SgfId.ADD_WHITE, SgfId.ADD_BLACK};
    private final Config config_;

    public static SgfRectangle calcStandardArea(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        SgfSize sgfSize = rootGameTree.getSize();
        ArrayList<SgfPoint> arrayList = new ArrayList<SgfPoint>(sgfSize.width() * sgfSize.height());
        UpdateVwFilter.addAllStones(rootGameTree, sgfSize, arrayList);
        if (arrayList.isEmpty()) {
            return null;
        }
        SgfRectangle sgfRectangle = SgfRectangle.create(arrayList.toArray(new SgfPoint[arrayList.size()]));
        SgfPoint sgfPoint = sgfRectangle.getStart();
        sgfPoint = sgfPoint.x() <= 4 ? SgfPoint.create(sgfSize, 1, sgfPoint.y()) : SgfPoint.create(sgfSize, sgfPoint.x() - 1, sgfPoint.y());
        sgfPoint = sgfPoint.y() <= 4 ? SgfPoint.create(sgfSize, sgfPoint.x(), 1) : SgfPoint.create(sgfSize, sgfPoint.x(), sgfPoint.y() - 1);
        SgfPoint sgfPoint2 = sgfRectangle.getEnd();
        sgfPoint2 = sgfSize.width() - 4 < sgfPoint2.x() ? SgfPoint.create(sgfSize, sgfSize.width(), sgfPoint2.y()) : SgfPoint.create(sgfSize, sgfPoint2.x() + 1, sgfPoint2.y());
        SgfPoint sgfPoint3 = sgfPoint2 = sgfSize.height() - 4 < sgfPoint2.y() ? SgfPoint.create(sgfSize, sgfPoint2.x(), sgfSize.height()) : SgfPoint.create(sgfSize, sgfPoint2.x(), sgfPoint2.y() + 1);
        if (sgfPoint.x() == 1 && sgfPoint.y() == 1 && sgfPoint2.x() == sgfSize.width() && sgfPoint2.y() == sgfSize.height()) {
            return null;
        }
        sgfRectangle.set(sgfPoint, sgfPoint2);
        return sgfRectangle;
    }

    private static void addAllStones(GameTree gameTree, SgfSize sgfSize, List<SgfPoint> list) {
        for (Node node : gameTree.getSequence()) {
            for (SgfId sgfId : STONES) {
                Property property = node.getProperty(sgfId);
                if (property == null) continue;
                list.addAll(Arrays.asList(SgfPoint.parse(sgfSize, property.getStrings())));
            }
        }
        for (GameTree gameTree2 : gameTree.getChildren()) {
            UpdateVwFilter.addAllStones(gameTree2, sgfSize, list);
        }
    }

    public UpdateVwFilter(Config config) {
        ArgumentChecker.throwIfNull((Object)config);
        this.config_ = config;
    }

    public UpdateVwFilter(Filter<RootGameTree> filter, Config config) {
        super(filter);
        ArgumentChecker.throwIfNull((Object)config);
        this.config_ = config;
    }

    @Override
    public RootGameTree filter(RootGameTree rootGameTree) throws FilterException {
        RootGameTree rootGameTree2 = super.filter(rootGameTree);
        switch (this.config_) {
            case REMOVE: {
                this.remove(rootGameTree2);
            }
            case STANDARD: {
                this.setStandard(rootGameTree2);
            }
        }
        return rootGameTree2;
    }

    private void setStandard(RootGameTree rootGameTree) {
        SgfRectangle sgfRectangle = UpdateVwFilter.calcStandardArea(rootGameTree);
        if (sgfRectangle != null) {
            Property property = new Property(SgfId.VIEW, sgfRectangle.getValue());
            rootGameTree.getSequence().getFirst().addProperty(property);
        }
    }

    private void remove(GameTree gameTree) {
        Sequence sequence = gameTree.getSequence();
        Node node = BasicFinder.findNode(sequence, SgfId.VIEW);
        while (node != null) {
            node.removeProperty(SgfId.VIEW);
            node = BasicFinder.findNode(sequence, SgfId.VIEW);
        }
        for (GameTree gameTree2 : gameTree.getChildren()) {
            this.remove(gameTree2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Config {
        STANDARD,
        REMOVE;

    }
}

