/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.pc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.pc.ProblemConverter;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProblemConverter
implements ProblemConverter {
    protected AbstractProblemConverter() {
    }

    @Override
    public void tuneForYukinoshita(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        SgfColor sgfColor = BasicFinder.firstMove(rootGameTree);
        if (sgfColor == null) {
            return;
        }
        SgfId sgfId = sgfColor.situationType();
        SgfId sgfId2 = sgfColor.opposite().situationType();
        Property property = new Property(sgfId, SgfDouble.EMPHASIZED.getString());
        Property property2 = new Property(sgfId2, SgfDouble.EMPHASIZED.getString());
        this.arrangeVariation(rootGameTree);
        this.addYukinoshitaConfig(rootGameTree, property, property2, true);
        rootGameTree.setGameType(GameType.PROBLEM);
    }

    protected void arrangeVariation(RootGameTree rootGameTree) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.findCorrectPath(rootGameTree, arrayList);
        GameTree gameTree = rootGameTree;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (n != 0) {
                gameTree.swapGameTree(0, n);
            }
            gameTree = gameTree.getChild(0);
        }
    }

    protected abstract boolean findCorrectPath(GameTree var1, List<Integer> var2);

    protected abstract void addYukinoshitaConfig(GameTree var1, Property var2, Property var3, boolean var4);

    protected void addSituationTag(GameTree gameTree, Property property, boolean bl) {
        Node node;
        if (gameTree.getChildrenSize() != 0) {
            int n = 0;
            for (GameTree gameTree2 : gameTree.getChildren()) {
                this.addSituationTag(gameTree2, property, bl && n == 0);
                ++n;
            }
        } else if (!bl && (node = gameTree.getSequence().getLast()) != null) {
            node.addProperty(property);
        }
    }
}

