/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.pc;

import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.cmd.RemoveLastNode;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.Stone;
import org.unitarou.sgf.util.pc.DefaultWrongProblemConverter;
import org.unitarou.util.ArgumentChecker;

class Goproblems
extends DefaultWrongProblemConverter {
    private static final String TAG_CORRECT = "CORRECT";
    private static final String TAG_RIGHT = "RIGHT";

    public boolean isSatisfied(GameTree gameTree) {
        for (Property property : BasicFinder.findAll(gameTree, SgfId.COMMENT)) {
            for (String string : property.getStrings()) {
                if (!this.isSatisfied(string)) continue;
                return true;
            }
        }
        for (GameTree gameTree2 : gameTree.getChildren()) {
            if (!this.isSatisfied(gameTree2)) continue;
            return true;
        }
        return false;
    }

    private boolean isSatisfied(String string) {
        return string.contains(TAG_RIGHT) || string.contains(TAG_CORRECT);
    }

    protected boolean isCorrectNode(Node node) {
        Property property = node.getProperty(SgfId.COMMENT);
        if (property == null) {
            return false;
        }
        boolean bl = false;
        for (String string : property.getStrings()) {
            bl |= this.isSatisfied(string);
        }
        return bl;
    }

    public void appendConfig(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        if (!rootGameTree.getGameType().equals(GameType.PROBLEM)) {
            throw new IllegalArgumentException();
        }
        SgfColor sgfColor = BasicFinder.firstMove(rootGameTree);
        if (sgfColor == null) {
            return;
        }
        Property property = new Property(sgfColor.situationType(), SgfDouble.EMPHASIZED.getString());
        boolean bl = true;
        this.appendConfigImpl(rootGameTree, property, bl);
        this.removePassBranch(rootGameTree, rootGameTree.getSize());
    }

    private void appendConfigImpl(GameTree gameTree, Property property, boolean bl) {
        for (GameTree[] gameTreeArray : gameTree.getSequence()) {
            Property property2 = gameTreeArray.getProperty(property.sgfId());
            if (!property.equals(property2)) continue;
            this.appendCorrectComment((Node)gameTreeArray);
            return;
        }
        if (gameTree.getChildrenSize() == 0 && bl) {
            Node node = gameTree.getSequence().getLast();
            this.appendCorrectComment(node);
            return;
        }
        int n = 0;
        for (GameTree gameTree2 : gameTree.getChildren()) {
            this.appendConfigImpl(gameTree2, property, bl && n == 0);
            ++n;
        }
    }

    private void appendCorrectComment(Node node) {
        Property property = node.getProperty(SgfId.COMMENT);
        if (property == null) {
            property = new Property(SgfId.COMMENT, TAG_CORRECT);
        } else {
            Value value = property.getValue();
            String string = value.getString() + TAG_CORRECT;
            property.setValue(new Value(string, value.getOpenUtr()));
        }
        node.addProperty(property);
    }

    private void removePassBranch(GameTree gameTree, SgfSize sgfSize) {
        SgfPoint sgfPoint = SgfPoint.createPass(sgfSize);
        Sequence sequence = gameTree.getSequence();
        for (Node node : sequence) {
            Stone stone = Stone.create(node, sgfSize);
            if (!sgfPoint.equals(stone.getPoint())) continue;
            gameTree.clearGameTree();
            Node node2 = null;
            while (node2 != node) {
                node2 = sequence.getLast();
                new RemoveLastNode(gameTree).execute();
            }
            return;
        }
        for (GameTree gameTree2 : gameTree.getChildren()) {
            this.removePassBranch(gameTree2, sgfSize);
        }
    }

    public void removeConfig(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        this.removeConfigImpl(rootGameTree);
    }

    private void removeConfigImpl(GameTree gameTree) {
        for (Node node : gameTree.getSequence()) {
            Property property = node.getProperty(SgfId.COMMENT);
            if (property == null) continue;
            Value object = property.getValue();
            StringBuilder stringBuilder = new StringBuilder(object.getString());
            this.delete(stringBuilder, TAG_CORRECT);
            this.delete(stringBuilder, TAG_RIGHT);
            property.setValue(new Value(stringBuilder, object.getOpenUtr()));
            node.addProperty(property);
        }
        for (GameTree gameTree2 : gameTree.getChildren()) {
            this.removeConfigImpl(gameTree2);
        }
    }

    private void delete(StringBuilder stringBuilder, String string) {
        int n = stringBuilder.indexOf(string);
        while (n != -1) {
            stringBuilder.delete(n, n + string.length());
            n = stringBuilder.indexOf(string);
        }
    }
}

