/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util.provider.plp;

import org.unitarou.ml.Message;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.util.provider.plp.BasicPropertyLabelProvider;
import org.unitarou.util.ArgumentChecker;

public class GwGbLabelProvider
extends BasicPropertyLabelProvider {
    private static final Message LB_CORRECT = new Message(GwGbLabelProvider.class, "lbCorrect");
    private static final Message LB_QUASI_CORRECT = new Message(GwGbLabelProvider.class, "lbQuasiCorrect");
    private static final Message LB_WRONG = new Message(GwGbLabelProvider.class, "lbWrong");
    private SgfColor playerColor_;

    public SgfColor getPlayerColor() {
        return this.playerColor_;
    }

    public void setPlayerColor(SgfColor sgfColor) {
        this.playerColor_ = sgfColor;
    }

    public String getLabel(GameType gameType, Property property) {
        ArgumentChecker.throwIfNull((Object)property);
        if (!gameType.equals(GameType.PROBLEM) || this.playerColor_ == null) {
            return super.getLabel(gameType, property);
        }
        if (!this.playerColor_.situationType().equals(property.sgfId())) {
            return LB_WRONG.get();
        }
        SgfDouble sgfDouble = SgfDouble.parseQuietly(property.getString());
        if (sgfDouble == null || sgfDouble.equals(SgfDouble.NORMAL)) {
            return LB_QUASI_CORRECT.get();
        }
        return LB_CORRECT.get();
    }
}

