/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.unitarou.sql.CheckerResultType;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CheckerResult {
    private final String message_;
    private final CheckerResultType result_;
    private final List<CheckerResult> children_;

    public CheckerResult(String string, CheckerResultType checkerResultType) {
        ArgumentChecker.throwIfNull((Object)string, (Object)checkerResultType);
        this.message_ = string;
        this.result_ = checkerResultType;
        this.children_ = new ArrayList<CheckerResult>(0);
    }

    public CheckerResult(CheckerResult checkerResult, String string, CheckerResultType checkerResultType) {
        ArgumentChecker.throwIfNull((Object)checkerResult, (Object)string, (Object)checkerResultType);
        this.message_ = string;
        this.result_ = checkerResultType;
        this.children_ = new ArrayList<CheckerResult>(0);
        if (checkerResult != null) {
            checkerResult.addChild(this);
        }
    }

    public void addChild(CheckerResult checkerResult) {
        ArgumentChecker.throwIfNull((Object)checkerResult);
        if (checkerResult == this) {
            throw new IllegalArgumentException("Self-addition is prohibited.");
        }
        if (checkerResult.hasDesendant(this)) {
            throw new IllegalArgumentException("Circular-addition is prohibited.");
        }
        this.children_.add(checkerResult);
    }

    private boolean hasDesendant(CheckerResult checkerResult) {
        if (this.children_.contains(checkerResult)) {
            return true;
        }
        for (CheckerResult checkerResult2 : this.children_) {
            if (!checkerResult2.hasDesendant(checkerResult)) continue;
            return true;
        }
        return false;
    }

    public CheckerResultType getTreeType() {
        ArrayList<CheckerResultType> arrayList = new ArrayList<CheckerResultType>(1 + this.children_.size());
        arrayList.add(this.result_);
        for (CheckerResult object : this.children_) {
            arrayList.add(object.getTreeType());
        }
        Object object = CheckerResultType.MATCH;
        for (CheckerResultType checkerResultType : arrayList) {
            switch (checkerResultType) {
                case UNMATCH: {
                    return CheckerResultType.UNMATCH;
                }
                case NOT_FOUND: {
                    object = CheckerResultType.NOT_FOUND;
                    break;
                }
            }
        }
        return object;
    }

    public CheckerResultType getType() {
        return this.result_;
    }

    public List<CheckerResult> getChildren() {
        return Collections.unmodifiableList(this.children_);
    }

    public String getMessage() {
        return this.message_;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((Object)this.result_).append('/').append(this.message_);
        return stringBuilder.toString();
    }
}

