/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.ImageData;
import org.unitarou.util.ArgumentChecker;

public class AlphaBlender {
    private static final Log log_s_ = LogFactory.getLog(AlphaBlender.class);

    public static ImageData createTransparent(ImageData imageData, int n) {
        ImageData imageData2 = new ImageData(imageData.width, imageData.height, imageData.depth, imageData.palette);
        int[] nArray = new int[imageData.width];
        byte[] byArray = new byte[imageData.width];
        byte by = 127 < n ? (byte)(n - 256) : (byte)n;
        for (int i = 0; i < imageData.height; ++i) {
            imageData.getPixels(0, i, nArray.length, nArray, 0);
            imageData.getAlphas(0, i, byArray.length, byArray, 0);
            for (int j = 0; j < byArray.length; ++j) {
                byArray[j] = nArray[j] == imageData.transparentPixel ? (byte)0 : AlphaBlender.moreTransparent(by, byArray[j]);
            }
            imageData2.setPixels(0, i, nArray.length, nArray, 0);
            imageData2.setAlphas(0, i, byArray.length, byArray, 0);
        }
        return imageData2;
    }

    public static byte[] createAlphaByPixels(ImageData imageData) {
        ArgumentChecker.throwIfNull((Object)imageData);
        byte[] byArray = new byte[imageData.height * imageData.width];
        if (!imageData.palette.isDirect) {
            log_s_.warn("createAlphaByPixels() does not support color palette.");
            return byArray;
        }
        int[] nArray = new int[byArray.length];
        imageData.getPixels(0, 0, nArray.length, nArray, 0);
        int n = imageData.palette.redShift > 0 ? 0 : imageData.palette.redShift;
        int n2 = imageData.palette.redMask;
        int n3 = 8 - Integer.bitCount(n2);
        byte by = (byte)(255 >> n3 << n3);
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)((nArray[i] & n2) >> -n);
            if (byArray[i] != by) continue;
            byArray[i] = -1;
        }
        return byArray;
    }

    public static byte opaquer(byte by, byte by2) {
        if (0 <= by && 0 <= by2 || by < 0 && by2 < 0) {
            return by < by2 ? by2 : by;
        }
        return by < by2 ? by : by2;
    }

    public static byte moreTransparent(byte by, byte by2) {
        if (0 <= by && 0 <= by2 || by < 0 && by2 < 0) {
            return by < by2 ? by : by2;
        }
        return by < by2 ? by2 : by;
    }

    protected AlphaBlender() {
    }
}

