/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.unitarou.swt.UTableProvider;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTable<T>
implements WidgetContainer {
    private Table table_;
    private final int tableStyle_;
    private final UTableProvider<T> provider_;
    private final List<T> records_;
    private final List<T> orgRecords_;

    public UTable(UTableProvider<T> uTableProvider, Collection<T> collection, int n) {
        ArgumentChecker.throwIfNull(uTableProvider, collection);
        this.table_ = null;
        this.tableStyle_ = n;
        this.provider_ = uTableProvider;
        this.records_ = new ArrayList<T>(collection);
        this.orgRecords_ = new ArrayList<T>(collection);
    }

    public UTable(UTableProvider<T> uTableProvider, Collection<T> collection) {
        this(uTableProvider, collection, 0);
    }

    public UTable(UTableProvider<T> uTableProvider, T[] TArray) {
        this(uTableProvider, Arrays.asList(TArray));
    }

    public UTable(UTableProvider<T> uTableProvider, int n) {
        this(uTableProvider, Collections.emptyList(), n);
    }

    public UTable(UTableProvider<T> uTableProvider) {
        this(uTableProvider, Collections.emptyList());
    }

    @Override
    public void close() {
    }

    @Override
    public Table createContents(Composite composite) {
        int n;
        this.table_ = new Table(composite, 0x10000800 | this.tableStyle_);
        this.table_.setHeaderVisible(true);
        TableColumn[] tableColumnArray = new TableColumn[this.provider_.getColumnSize()];
        for (int i = 0; i < tableColumnArray.length; ++i) {
            tableColumnArray[i] = new TableColumn(this.table_, 16384);
        }
        this.provider_.setup(tableColumnArray);
        this.table_.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TableItem tableItem = (TableItem)event.item;
                int n = UTable.this.table_.indexOf(tableItem);
                UTable.this.provider_.set(tableItem, UTable.this.records_.get(n));
            }
        });
        boolean[] blArray = this.provider_.getSotableColums();
        SortListener sortListener = new SortListener();
        for (n = 0; n < blArray.length; ++n) {
            if (!blArray[n]) continue;
            tableColumnArray[n].addListener(13, sortListener);
        }
        this.table_.setItemCount(this.records_.size());
        for (n = 0; n < this.table_.getColumnCount(); ++n) {
            this.table_.getColumn(n).pack();
        }
        return this.table_;
    }

    @Override
    public Table getControl() {
        return this.table_;
    }

    public List<T> getRecords() {
        return Collections.unmodifiableList(this.records_);
    }

    public void add(T t) {
        ArgumentChecker.throwIfNull(t);
        this.records_.add(t);
        this.orgRecords_.add(t);
        this.sort();
        this.table_.clearAll();
        this.table_.setItemCount(this.records_.size());
        for (int i = 0; i < this.table_.getColumnCount(); ++i) {
            this.table_.getColumn(i).pack();
        }
    }

    public void addAll(Collection<T> collection) {
        ArgumentChecker.throwIfNull(collection);
        this.records_.addAll(collection);
        this.orgRecords_.addAll(collection);
        this.sort();
        this.table_.clearAll();
        this.table_.setItemCount(this.records_.size());
        for (int i = 0; i < this.table_.getColumnCount(); ++i) {
            this.table_.getColumn(i).pack();
        }
    }

    public void removeSelected() {
        int[] nArray = this.table_.getSelectionIndices();
        ArrayList<T> arrayList = new ArrayList<T>(nArray.length);
        for (int n : nArray) {
            arrayList.add(this.records_.get(n));
        }
        this.records_.removeAll(arrayList);
        this.orgRecords_.removeAll(arrayList);
        this.table_.remove(nArray);
    }

    public void clear() {
        this.records_.clear();
        this.orgRecords_.clear();
        this.table_.clearAll();
        this.table_.setItemCount(0);
    }

    public void update() {
        this.table_.clearAll();
    }

    private void sort() {
        int n = this.table_.getSortDirection();
        TableColumn tableColumn = this.table_.getSortColumn();
        if (n == 0 || tableColumn == null) {
            return;
        }
        final int n2 = this.table_.indexOf(tableColumn);
        final int n3 = n == 128 ? 1 : -1;
        Collections.sort(this.records_, new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                return n3 * UTable.this.provider_.compareTo(t, t2, n2);
            }
        });
    }

    private class SortListener
    implements Listener {
        private SortListener() {
        }

        public void handleEvent(Event event) {
            TableColumn tableColumn = (TableColumn)event.widget;
            int n = UTable.this.table_.indexOf(tableColumn);
            if (!UTable.this.provider_.getSotableColums()[n]) {
                UTable.this.table_.setSortColumn(null);
                UTable.this.records_.clear();
                UTable.this.records_.addAll(UTable.this.orgRecords_);
                UTable.this.table_.clearAll();
                return;
            }
            int n2 = this.changeSortCondition(tableColumn);
            UTable.this.table_.setSortDirection(n2);
            if (n2 == 0) {
                UTable.this.records_.clear();
                UTable.this.records_.addAll(UTable.this.orgRecords_);
            } else {
                UTable.this.sort();
            }
            UTable.this.table_.clearAll();
        }

        int changeSortCondition(TableColumn tableColumn) {
            TableColumn tableColumn2 = UTable.this.table_.getSortColumn();
            if (tableColumn2 != tableColumn) {
                UTable.this.table_.setSortColumn(tableColumn);
                return 128;
            }
            int n = UTable.this.table_.getSortDirection();
            switch (n) {
                case 128: {
                    return 1024;
                }
                case 1024: {
                    return 0;
                }
                case 0: {
                    return 128;
                }
            }
            assert (false) : "Unknown direction: " + n;
            return 0;
        }
    }
}

