/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.util;

import java.util.Collection;
import org.unitarou.lang.NullArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentChecker {
    public static void throwIfNull(Object object) {
        if (object == null) {
            throw new NullArgumentException(object);
        }
    }

    public static void throwIfNull(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullArgumentException(object, object2);
        }
    }

    public static void throwIfNull(Object object, Object object2, Object object3) {
        if (object == null || object2 == null || object3 == null) {
            throw new NullArgumentException(object, object2, object3);
        }
    }

    public static void throwIfNull(Object object, Object object2, Object object3, Object object4) {
        if (object == null || object2 == null || object3 == null || object4 == null) {
            throw new NullArgumentException(object, object2, object3, object4);
        }
    }

    public static void throwIfNull(Object ... objectArray) {
        if (objectArray == null) {
            throw new NullArgumentException("Argument array must not be null.");
        }
        for (Object object : objectArray) {
            if (object != null) continue;
            throw new NullArgumentException(objectArray);
        }
    }

    public static void throwIfZeroOrLess(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Argument must not be One or more. Parameter is " + n);
        }
    }

    public static void throwIfNegative(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Argument must not be minus value. Parameter is " + n);
        }
    }

    public static void throwsIfOutOfBounds(int n, Collection<?> collection) {
        ArgumentChecker.throwIfNull((Object)new Integer(n), collection);
        if (n < 0 || collection.size() <= n) {
            throw new IllegalArgumentException();
        }
    }

    public static void throwIfDifferentLength(byte[][] byArray, byte[][] byArray2) {
        ArgumentChecker.throwIfNull(byArray, byArray2);
        if (byArray.length != byArray2.length) {
            throw new IllegalArgumentException("Array size must be same, but: arg1.length=" + byArray.length + ", arg2.length=" + byArray2.length);
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i].length == byArray2[i].length) continue;
            throw new IllegalArgumentException("Array size must be same, but: arg1[" + i + "].length=" + byArray[i].length + ", arg2[" + i + "].length=" + byArray2[i].length);
        }
    }

    public static boolean isNull(Object ... objectArray) {
        for (Object object : objectArray) {
            if (object != null) continue;
            return true;
        }
        return false;
    }

    protected ArgumentChecker() {
    }
}

