/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.util;

import java.util.Arrays;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.StopWatch;

public class PeriodPredictor {
    private final long[] nanos_;
    private int index_;
    private int count_;
    private final StopWatch stopWatch_;

    public PeriodPredictor() {
        this(1000);
    }

    public PeriodPredictor(int n) {
        ArgumentChecker.throwIfNegative(n);
        this.nanos_ = new long[n];
        this.index_ = 0;
        this.count_ = 0;
        this.stopWatch_ = new StopWatch(false);
    }

    public void start() {
        Arrays.fill(this.nanos_, 0L);
        this.index_ = 0;
        this.count_ = 0;
        this.stopWatch_.start();
    }

    public void lap() {
        this.nanos_[this.index_] = this.stopWatch_.lap();
        this.index_ = (this.index_ + 1) % this.nanos_.length;
        ++this.count_;
    }

    public long average() {
        if (this.count_ == 0) {
            return 0L;
        }
        long l = 0L;
        int n = Math.min(this.count_, this.nanos_.length);
        for (int i = 0; i < n; ++i) {
            l += this.nanos_[i];
        }
        return l / (long)n;
    }

    public long passing() {
        return this.stopWatch_.passing();
    }
}

