/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfReal;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.Situation;
import org.unitarou.sgf.util.Stone;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeTree;
import org.unitarou.yukinoshita.model.RootView;
import org.unitarou.yukinoshita.model.board.IgoBoard;
import org.unitarou.yukinoshita.model.board.IgoBoardView;
import org.unitarou.yukinoshita.model.board.InheritableMarker;
import org.unitarou.yukinoshita.model.board.OverblockMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeView {
    private final NodeEntity nodeEntity_;
    private final RootView rootView_;

    public NodeView(NodeEntity nodeEntity) {
        ArgumentChecker.throwIfNull((Object)nodeEntity);
        this.nodeEntity_ = nodeEntity;
        this.rootView_ = new RootView(this.nodeEntity_.getNodeTree().getRootGameTree());
    }

    public RootView getRootView() {
        return this.rootView_;
    }

    public NodeList getNodeList() {
        return this.nodeEntity_.getNodeList();
    }

    public boolean isSameNodeEntity(NodeView nodeView) {
        ArgumentChecker.throwIfNull((Object)nodeView);
        return this.nodeEntity_.equals(nodeView.nodeEntity_);
    }

    public IgoBoardView getIgoBoard() {
        return this.nodeEntity_.getIgoBoard();
    }

    public InheritableMarker getInheritableDecoration() {
        return this.nodeEntity_.getInheritableDecoration();
    }

    public boolean containsPropertyType(PropertyType propertyType) {
        ArgumentChecker.throwIfNull((Object)propertyType);
        for (SgfId sgfId : this.nodeEntity_.getNode().getPropertyIds()) {
            if (sgfId.propertyType() != propertyType) continue;
            return true;
        }
        return false;
    }

    public int variationSize() {
        return this.nodeEntity_.getNodeTree().getVariationSize();
    }

    public NodeView[] getVariations() {
        NodeEntity[] nodeEntityArray = this.nodeEntity_.getVariations();
        NodeView[] nodeViewArray = new NodeView[nodeEntityArray.length];
        for (int i = 0; i < nodeViewArray.length; ++i) {
            nodeViewArray[i] = nodeEntityArray[i].getNodeView();
        }
        return nodeViewArray;
    }

    public Stone getMove() {
        return this.nodeEntity_.getMove();
    }

    public Property getProperty(SgfId sgfId) {
        return this.nodeEntity_.getNode().getProperty(sgfId);
    }

    public Property findProperty(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        NodeEntity nodeEntity = this.nodeEntity_.findAbove(sgfId.propertyType());
        if (nodeEntity == null) {
            return null;
        }
        return nodeEntity.getNode().getProperty(sgfId);
    }

    public boolean isChildrenStyle() {
        return this.nodeEntity_.getNodeTree().isChildrenStyle();
    }

    public SgfColor getOppositeColor() {
        return this.isChildrenStyle() ? this.getNextMoveColor() : this.getMove().getColor();
    }

    public int getSelectedVariationIndex() {
        return this.nodeEntity_.getSelectedVariationIndex();
    }

    public int getVariationHash() {
        int n = -1;
        for (NodeEntity nodeEntity = this.nodeEntity_; nodeEntity != null; nodeEntity = nodeEntity.getPrevious()) {
            int n2 = nodeEntity.getSelectedVariationIndex();
            if (n2 == -1) continue;
            n += n2;
        }
        return n;
    }

    public OverblockMarker getOverblockMarker() {
        return new OverblockMarker(this.nodeEntity_.getNode());
    }

    public SgfSize getSize() {
        return this.nodeEntity_.getNodeTree().getSize();
    }

    public List<Stone> getCaptured(SgfColor sgfColor) {
        ArgumentChecker.throwIfNull((Object)sgfColor);
        return this.nodeEntity_.getIgoBoard().getCaptured(sgfColor);
    }

    public SgfColor getNextMoveColor() {
        NodeEntity nodeEntity = this.nodeEntity_;
        do {
            Object object;
            if (nodeEntity.getNode().contains(PropertyType.SETUP)) {
                SgfColor sgfColor;
                object = nodeEntity.getNode().getProperty(SgfId.PLAYER_TO_PLAY);
                if (object == null || (sgfColor = SgfColor.parseQuietly(((Property)object).getString())) == null) break;
                return sgfColor;
            }
            object = nodeEntity.getMove().getColor();
            if (object == null) continue;
            return ((SgfColor)object).opposite();
        } while ((nodeEntity = nodeEntity.getPrevious()) != null);
        if ((nodeEntity = this.nodeEntity_.getNext()) != null) {
            return nodeEntity.getMove().getColor();
        }
        return null;
    }

    public boolean isFirst() {
        return this.nodeEntity_.getPrevious() == null;
    }

    public boolean isLast() {
        NodeTree nodeTree = this.nodeEntity_.getNodeTree();
        return nodeTree.getGameTree().getChildrenSize() == 0 && nodeTree.isLastNode();
    }

    public EnumSet<SgfPointType> getPointTypes(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        EnumSet<SgfPointType> enumSet = EnumSet.noneOf(SgfPointType.class);
        IgoBoard igoBoard = this.nodeEntity_.getIgoBoard();
        if (igoBoard == null) {
            enumSet.add(SgfPointType.FORBIDDEN);
            enumSet.add(SgfPointType.EMPTY);
            return enumSet;
        }
        Stone stone = igoBoard.getStone(sgfPoint);
        if (stone == null) {
            enumSet.add(SgfPointType.EMPTY);
        } else if (SgfColor.BLACK.equals(stone.getColor())) {
            enumSet.add(SgfPointType.BLACK);
        } else if (SgfColor.WHITE.equals(stone.getColor())) {
            enumSet.add(SgfPointType.WHITE);
        } else assert (false) : "Known types are found:" + stone.getColor();
        Stone stone2 = this.nodeEntity_.getMove();
        if (stone2.isValid() && igoBoard.isForbiddenMove(sgfPoint, stone2.getColor().opposite(), stone2.getPoint(), this.nodeEntity_.getLastCaptured())) {
            enumSet.add(SgfPointType.FORBIDDEN);
        }
        return enumSet;
    }

    public SgfPointType getPointTypes4Variation(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        if (this.isChildrenStyle()) {
            EnumSet<SgfPointType> enumSet = this.getPointTypes(sgfPoint);
            return enumSet.contains((Object)SgfPointType.FORBIDDEN) ? SgfPointType.FORBIDDEN : SgfPointType.EMPTY;
        }
        NodeEntity nodeEntity = this.nodeEntity_.getPrevious();
        if (nodeEntity == null || nodeEntity.getIgoBoard().getStone(sgfPoint) != null) {
            return SgfPointType.FORBIDDEN;
        }
        if (!nodeEntity.getMove().isValid()) {
            return SgfPointType.EMPTY;
        }
        return nodeEntity.getIgoBoard().isForbiddenMove(sgfPoint, nodeEntity.getMove().getColor().opposite(), nodeEntity.getMove().getPoint(), nodeEntity.getLastCaptured()) ? SgfPointType.FORBIDDEN : SgfPointType.EMPTY;
    }

    public Situation getSituation() {
        int[] nArray = this.countScore(SgfId.TERRITORY_BLACK);
        int[] nArray2 = this.countScore(SgfId.TERRITORY_WHITE);
        if (nArray[0] == 0 && nArray2[0] == 0) {
            return new Situation(0, 0, 0, 0, 0.0);
        }
        nArray[1] = nArray[1] + this.getCaptured(SgfColor.BLACK).size();
        nArray2[1] = nArray2[1] + this.getCaptured(SgfColor.WHITE).size();
        Property property = this.findProperty(SgfId.KOMI);
        double d = property == null ? 0.0 : SgfReal.parseQuietly(property.getString()).getReal();
        return new Situation(nArray2[0], nArray2[1], nArray[0], nArray[1], d);
    }

    private int[] countScore(SgfId sgfId) {
        assert (sgfId == SgfId.TERRITORY_BLACK || sgfId == SgfId.TERRITORY_WHITE);
        Node node = this.nodeEntity_.getNode();
        Property property = node.getProperty(sgfId);
        if (property == null) {
            return new int[]{0, 0};
        }
        SgfPoint[] sgfPointArray = SgfPoint.parse(this.getSize(), property.getStrings());
        int[] nArray = new int[]{0, 0};
        SgfColor sgfColor = SgfColor.getColor(sgfId);
        IgoBoard igoBoard = this.nodeEntity_.getIgoBoard();
        for (SgfPoint sgfPoint : sgfPointArray) {
            Stone stone = igoBoard.getStone(sgfPoint);
            if (stone == null) {
                nArray[0] = nArray[0] + 1;
                continue;
            }
            if (sgfColor.equals(stone.getColor())) continue;
            nArray[0] = nArray[0] + 1;
            nArray[1] = nArray[1] + 1;
        }
        return nArray;
    }

    public Set<SgfPoint> getInvalid() {
        return this.nodeEntity_.getInvalid();
    }

    public boolean appends(SgfId sgfId) {
        return this.nodeEntity_.appends(sgfId);
    }

    public Node copyNode() {
        return new Node(this.nodeEntity_.getNode());
    }
}

