/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model;

import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.FileFormat;
import org.unitarou.sgf.type.GameMode;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfApplication;
import org.unitarou.sgf.type.SgfCharset;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.Style;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.util.ArgumentChecker;

public class RootView {
    private final RootGameTree rootGameTree_;

    public RootView(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        this.rootGameTree_ = rootGameTree;
    }

    public SgfApplication getApplication() {
        return this.rootGameTree_.getApplication();
    }

    public SgfCharset getSgfCharset() {
        return this.rootGameTree_.getSgfCharset();
    }

    public FileFormat getFileFormat() {
        return this.rootGameTree_.getFileFormat();
    }

    public GameMode getGameMode() {
        return this.rootGameTree_.getGameMode();
    }

    public GameType getGameType() {
        return this.rootGameTree_.getGameType();
    }

    public SgfSize getSize() {
        return this.rootGameTree_.getSize();
    }

    public Style getStyle() {
        return this.rootGameTree_.getStyle();
    }

    public SgfColor firstMove() {
        SgfColor sgfColor = BasicFinder.firstMove(this.rootGameTree_);
        if (sgfColor != null) {
            return sgfColor;
        }
        Property property = BasicFinder.findProperty(this.rootGameTree_.getSequence(), SgfId.PLAYER_TO_PLAY);
        if (property == null) {
            return null;
        }
        return SgfColor.parseQuietly(property.getString());
    }
}

