/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.board;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfLine;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.util.ArgumentChecker;

public class OverblockMarker {
    private static final Set<SgfId> targetTypeSet_s_ = new TreeSet<SgfId>();
    private final Map<SgfId, Set<String>> typeValueMap_;

    public OverblockMarker() {
        this.typeValueMap_ = new TreeMap<SgfId, Set<String>>();
    }

    public OverblockMarker(Node node) {
        ArgumentChecker.throwIfNull((Object)node);
        this.typeValueMap_ = new TreeMap<SgfId, Set<String>>();
        for (Property property : node.getProperties()) {
            this.setImpl(property);
        }
    }

    public void set(Property property) {
        this.setImpl(property);
    }

    private void setImpl(Property property) {
        if (property == null) {
            return;
        }
        SgfId sgfId = property.sgfId();
        if (!targetTypeSet_s_.contains(sgfId)) {
            return;
        }
        Set<String> set = this.typeValueMap_.get(sgfId);
        if (set != null) {
            set.clear();
        } else {
            set = new TreeSet<String>();
            this.typeValueMap_.put(sgfId, set);
        }
        set.addAll(Arrays.asList(property.getStrings()));
    }

    public void set(OverblockMarker overblockMarker) {
        ArgumentChecker.throwIfNull((Object)overblockMarker);
        this.typeValueMap_.clear();
        this.typeValueMap_.putAll(overblockMarker.typeValueMap_);
    }

    public String[] get(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        Set<String> set = this.typeValueMap_.get(sgfId);
        if (set == null) {
            return new String[0];
        }
        return set.toArray(new String[set.size()]);
    }

    public Label[] getLabels(SgfSize sgfSize) {
        ArgumentChecker.throwIfNull((Object)sgfSize);
        String[] stringArray = this.get(SgfId.LABEL);
        ArrayList<Label> arrayList = new ArrayList<Label>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Label label = Label.parseQuietly(sgfSize, stringArray[i]);
            if (label == null) continue;
            arrayList.add(label);
        }
        return arrayList.toArray(new Label[arrayList.size()]);
    }

    public SgfLine[] getLine(SgfId sgfId, SgfSize sgfSize) {
        ArgumentChecker.throwIfNull((Object)sgfId, (Object)sgfSize);
        if (!sgfId.valueType().equals((Object)ValueType.CPOINT)) {
            throw new IllegalArgumentException("Bad type for getLine():" + sgfId);
        }
        String[] stringArray = this.get(sgfId);
        ArrayList<SgfLine> arrayList = new ArrayList<SgfLine>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                arrayList.add(SgfLine.parse(sgfSize, stringArray[i]));
                continue;
            }
            catch (TypeParseException typeParseException) {
                typeParseException.printStackTrace();
            }
        }
        return arrayList.toArray(new SgfLine[arrayList.size()]);
    }

    public boolean isEmpty() {
        for (Set<String> set : this.typeValueMap_.values()) {
            if (set.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.typeValueMap_.clear();
    }

    static {
        targetTypeSet_s_.add(SgfId.LABEL);
        targetTypeSet_s_.add(SgfId.LINE);
        targetTypeSet_s_.add(SgfId.ARROW);
    }
}

