/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.board;

import java.util.Collection;
import java.util.Set;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.board.StoneGroupImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StoneGroup
implements Comparable {
    private StoneGroupImpl impl_;

    public StoneGroup(SgfSize sgfSize) {
        ArgumentChecker.throwIfNull((Object)sgfSize);
        this.impl_ = new StoneGroupImpl(sgfSize);
    }

    public StoneGroup(StoneGroup stoneGroup) {
        ArgumentChecker.throwIfNull((Object)stoneGroup);
        this.impl_ = new StoneGroupImpl(stoneGroup.impl_);
    }

    private StoneGroup(StoneGroupImpl stoneGroupImpl) {
        assert (stoneGroupImpl != null);
        this.impl_ = new StoneGroupImpl(stoneGroupImpl);
    }

    public boolean add(SgfPoint sgfPoint, Collection<SgfPoint> collection) {
        ArgumentChecker.throwIfNull((Object)sgfPoint, collection);
        return this.impl_.add(sgfPoint, collection);
    }

    public void add(StoneGroup stoneGroup) {
        ArgumentChecker.throwIfNull((Object)stoneGroup);
        this.impl_.add(stoneGroup.impl_);
    }

    public StoneGroup[] remove(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        if (!this.impl_.contains(sgfPoint)) {
            throw new IllegalArgumentException();
        }
        StoneGroupImpl[] stoneGroupImplArray = this.impl_.remove(sgfPoint);
        this.impl_ = stoneGroupImplArray[0];
        StoneGroup[] stoneGroupArray = new StoneGroup[stoneGroupImplArray.length];
        stoneGroupArray[0] = this;
        for (int i = 1; i < stoneGroupImplArray.length; ++i) {
            stoneGroupArray[i] = new StoneGroup(stoneGroupImplArray[i]);
        }
        return stoneGroupArray;
    }

    public void addLifePoint(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        if (this.impl_.isNeighbor(sgfPoint)) {
            this.impl_.addLifePoint(sgfPoint);
        }
    }

    public boolean removeLifePoint(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)sgfPoint);
        if (this.impl_.isLifePoint(sgfPoint)) {
            return this.impl_.removeLifePoint(sgfPoint);
        }
        return false;
    }

    public Set<SgfPoint> stones() {
        return this.impl_.stones();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() == this.getClass()) {
            return false;
        }
        return this.impl_.equals(((StoneGroup)object).impl_);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public int compareTo(Object object) {
        StoneGroup stoneGroup = (StoneGroup)object;
        return System.identityHashCode(this.impl_) - System.identityHashCode(stoneGroup.impl_);
    }

    public int count() {
        return this.impl_.count();
    }

    public int countLifePoint() {
        return this.impl_.countLifePoint();
    }

    public boolean contains(SgfPoint sgfPoint) {
        return this.impl_.contains(sgfPoint);
    }

    public boolean isLifePoint(SgfPoint sgfPoint) {
        return this.impl_.isLifePoint(sgfPoint);
    }
}

