/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import org.unitarou.cmd.Command;
import org.unitarou.ml.Message;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeListEditor;
import org.unitarou.yukinoshita.model.NodeTree;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.sound.SoundEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddNode
extends Command4NodeList {
    private static final Message LB_NAME = new Message(AddNode.class, "lbName");
    private final Node node_;
    private Command sgfCommand_;
    private GameTree gameTree_;
    private NodeEntity addNodeEntity_;

    public AddNode(Node node) {
        ArgumentChecker.throwIfNull((Object)node);
        this.node_ = node;
        this.setDisplayName(LB_NAME.get());
    }

    @Override
    protected boolean setup() {
        if (this.sgfCommand_ != null) {
            return true;
        }
        NodeListEditor nodeListEditor = this.getEditableNodeList();
        if (nodeListEditor == null) {
            return false;
        }
        NodeTree nodeTree = nodeListEditor.getLast().getNodeTree();
        this.gameTree_ = nodeTree.getGameTree();
        this.sgfCommand_ = new org.unitarou.sgf.cmd.AddNode(this.gameTree_, this.node_);
        this.addNodeEntity_ = new NodeEntity(this.node_, this.gameTree_, nodeListEditor, nodeListEditor.size() == 0 ? null : nodeListEditor.getLast());
        this.setExecutedNodeIndex(nodeListEditor.size());
        this.setUndoneNodeIndex(nodeListEditor.size() - 1);
        return true;
    }

    @Override
    public void execute() {
        super.execute();
        this.sgfCommand_.execute();
        this.getEditableNodeList().addLast(this.addNodeEntity_);
        SgfPoint sgfPoint = this.addNodeEntity_.getMove().getPoint();
        if (sgfPoint != null && SgfPointType.IN.equals((Object)sgfPoint.condition())) {
            SoundEffect.MOVE.play();
        }
    }

    @Override
    public void undo() {
        super.undo();
        this.sgfCommand_.undo();
        NodeEntity nodeEntity = this.getEditableNodeList().removeLast();
        assert (nodeEntity == this.addNodeEntity_) : "Mismatch target node: " + nodeEntity + " <> " + this.addNodeEntity_;
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return EnumSet.of(ModelInfluence.NODE_CURRENT);
    }
}

