/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db;

import java.io.Closeable;
import java.io.File;
import java.util.List;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sql.CheckerResult;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.model.db.DatabaseException;
import org.unitarou.yukinoshita.model.db.DatabaseStatistics;
import org.unitarou.yukinoshita.model.db.FileIndex;
import org.unitarou.yukinoshita.model.db.GameIndex;
import org.unitarou.yukinoshita.model.db.GameTerm;
import org.unitarou.yukinoshita.model.db.Master;
import org.unitarou.yukinoshita.model.db.NullDatabase;
import org.unitarou.yukinoshita.model.db.Score;
import org.unitarou.yukinoshita.model.db.SearchFileCondition;
import org.unitarou.yukinoshita.model.db.SearchedFile;
import org.unitarou.yukinoshita.model.db.Term;
import org.unitarou.yukinoshita.model.db.TermFrequency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Database
extends Closeable {
    public static final Database NULL_OBJECT = new NullDatabase();
    public static final Message NT_CANT_START_DB = new Message(Database.class, "ntCantStartDb");
    public static final Message MSG_BAD_CONNECTION_URL = new Message(Database.class, "msgBadConnectionUrl");
    public static final Message MSG_DB_CANNOT_BE_USED_BY_INIT_ERROR = new Message(Database.class, "msgDbCannotBeUsedByInitError");
    public static final Message MSG_DB_CANNOT_BE_USED = new Message(Database.class, "msgDbCannotBeUsed");
    public static final Message MSG_REBUILD_DB = new Message(Database.class, "msgRebuildDb");
    public static final Message MSG_RECREATE_DB = new Message(Database.class, "msgRecreateDb");
    public static final ContextValue<Boolean> FORCE_DB_UPDATE = new ContextValue<Boolean>(Database.class, "forceDbUpdate", Boolean.TRUE);

    public void setup();

    public Exception getExceptionAtSetup();

    @Override
    public void close();

    public boolean updateDatabase();

    public CheckerResult selfCheck();

    public void create() throws DatabaseException;

    public Master selectMaster(RootGameTree var1) throws DatabaseException;

    public Master insertMaster(RootGameTree var1) throws DatabaseException;

    public FileIndex selectFileIndex(File var1) throws DatabaseException;

    public void refreshFileIndex(List<Collection> var1) throws DatabaseException;

    public boolean deleteFileIndex(int var1) throws DatabaseException;

    public boolean deleteAllFileIndices() throws DatabaseException;

    public int deleteNotFoundFileIndex() throws DatabaseException;

    public Score insertScore(RootGameTree var1, ProblemStatus var2, ProblemProperties var3, int var4) throws DatabaseException;

    public Score[] selectScores(RootGameTree var1) throws DatabaseException;

    public List<SearchedFile> search(SearchFileCondition var1) throws DatabaseException;

    public DatabaseStatistics selectStatistics() throws DatabaseException;

    public List<Term> search(GameIndex var1) throws DatabaseException;

    public List<TermFrequency> searchTermFrequency(SgfId var1, GameType var2) throws DatabaseException;

    public List<GameTerm> selectGameTerm(GameType var1, SgfId var2) throws DatabaseException;

    public Master selectMaster(int var1) throws DatabaseException;
}

