/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.unitarou.lang.Objects;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.util.ArgumentChecker;

public class GameIndex {
    private static final DateFormat[] formats_s_ = new DateFormat[]{new SimpleDateFormat("yyyy-mm-dd"), new SimpleDateFormat("yyyy-mm"), new SimpleDateFormat("yyyy")};
    private int fileId_;
    private int fileOrder_;
    private int masterId_;
    private int gameType_;
    private int move_;
    private String procedure_;
    private String date_;

    public GameIndex() {
    }

    public GameIndex(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        this.gameType_ = rootGameTree.getGameType().getIntValue();
        this.move_ = this.countMoves(rootGameTree);
        Property property = BasicFinder.findProperty(rootGameTree.getSequence(), SgfId.DATE);
        this.procedure_ = this.parseProcedure(rootGameTree);
        this.date_ = this.parseDate(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseDate(Property property) {
        if (property == null) {
            return null;
        }
        String string = property.getString().replace('/', '-');
        Date date = null;
        for (DateFormat dateFormat : formats_s_) {
            try {
                DateFormat dateFormat2 = dateFormat;
                synchronized (dateFormat2) {
                    date = dateFormat.parse(string);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (date == null) continue;
            return string;
        }
        return null;
    }

    private String parseProcedure(RootGameTree rootGameTree) {
        StringBuilder stringBuilder = new StringBuilder(this.move_ * 2);
        this.parseProcedureImpl(stringBuilder, rootGameTree);
        return stringBuilder.toString();
    }

    private void parseProcedureImpl(StringBuilder stringBuilder, GameTree gameTree) {
        SgfColor sgfColor = SgfColor.BLACK;
        for (Node node : gameTree.getSequence()) {
            Property property = node.getProperty(sgfColor.moveType());
            if (property == null) {
                sgfColor = sgfColor.opposite();
                property = node.getProperty(sgfColor.moveType());
            }
            if (property == null) continue;
            stringBuilder.append(property.getString());
            sgfColor = sgfColor.opposite();
        }
        GameTree[] gameTreeArray = gameTree.getChildren();
        if (gameTreeArray.length != 0) {
            this.parseProcedureImpl(stringBuilder, gameTreeArray[0]);
        }
    }

    private int countMoves(GameTree gameTree) {
        int n = 0;
        for (Node node : gameTree.getSequence()) {
            if (node.contains(SgfId.BLACK)) {
                ++n;
            }
            if (!node.contains(SgfId.WHITE)) continue;
            ++n;
        }
        if (0 < gameTree.getChildrenSize()) {
            n += this.countMoves(gameTree.getChild(0));
        }
        return n;
    }

    public int getFileId() {
        return this.fileId_;
    }

    public void setFileId(int n) {
        this.fileId_ = n;
    }

    public int getFileOrder() {
        return this.fileOrder_;
    }

    public void setFileOrder(int n) {
        this.fileOrder_ = n;
    }

    public int getMasterId() {
        return this.masterId_;
    }

    public void setMasterId(int n) {
        this.masterId_ = n;
    }

    public int getGameType() {
        return this.gameType_;
    }

    public void setGameType(int n) {
        this.gameType_ = n;
    }

    public int getMove() {
        return this.move_;
    }

    public void setMove(int n) {
        this.move_ = n;
    }

    public String getProcedure() {
        return this.procedure_;
    }

    public void setProcedure(String string) {
        this.procedure_ = string;
    }

    public String getDate() {
        return this.date_;
    }

    public void setDate(String string) {
        this.date_ = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass().equals(this.getClass())) {
            return false;
        }
        GameIndex gameIndex = (GameIndex)object;
        return this.equals(gameIndex);
    }

    public final boolean equals(GameIndex gameIndex) {
        if (gameIndex == null) {
            return false;
        }
        return this.fileId_ == gameIndex.fileId_ && this.fileOrder_ == gameIndex.fileOrder_ && this.masterId_ == gameIndex.masterId_ && this.gameType_ == gameIndex.gameType_ && this.move_ == gameIndex.move_ && Objects.equalsIncludeNull(this.procedure_, gameIndex.procedure_) && Objects.equalsIncludeNull(this.date_, gameIndex.date_);
    }

    public int hashCode() {
        return this.fileId_ * 1999 + this.fileOrder_ * 1009 + this.masterId_ * 599 + this.gameType_ * 191 + this.move_ + Objects.hashCodeIncludeNull(this.procedure_) * 91 + Objects.hashCodeIncludeNull(this.date_) * 71;
    }
}

