/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db;

import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.Fingerprints;
import org.unitarou.util.ArgumentChecker;

public class Master {
    private int masterId_;
    private int gameType_;
    private int width_;
    private int height_;
    private byte[] fingerprint_;

    public Master() {
        this.fingerprint_ = new byte[0];
    }

    public Master(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        SgfSize sgfSize = rootGameTree.getSize();
        this.gameType_ = Byte.parseByte(rootGameTree.getGameType().getString());
        this.width_ = sgfSize.width();
        this.height_ = sgfSize.height();
        this.fingerprint_ = Fingerprints.calcFingerprintArray(rootGameTree);
    }

    public int getMasterId() {
        return this.masterId_;
    }

    public void setMasterId(int n) {
        this.masterId_ = n;
    }

    public int getGameType() {
        return this.gameType_;
    }

    public void setGameType(int n) {
        this.gameType_ = n;
    }

    public int getWidth() {
        return this.width_;
    }

    public void setWidth(int n) {
        this.width_ = n;
    }

    public int getHeight() {
        return this.height_;
    }

    public void setHeight(int n) {
        this.height_ = n;
    }

    public byte[] getFingerprint() {
        byte[] byArray = new byte[this.fingerprint_.length];
        System.arraycopy(this.fingerprint_, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public void setFingerprint(byte[] byArray) {
        if (byArray == null) {
            this.fingerprint_ = new byte[0];
        } else {
            this.fingerprint_ = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.fingerprint_, 0, this.fingerprint_.length);
        }
    }
}

