/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.Fingerprints;
import org.unitarou.sql.ForeignKey;
import org.unitarou.sql.PrimaryKey;
import org.unitarou.sql.UBeanHandler;
import org.unitarou.sql.UQueryRunner;
import org.unitarou.yukinoshita.model.db.Master;
import org.unitarou.yukinoshita.model.db.hsql.AbstractTable;
import org.unitarou.yukinoshita.model.db.hsql.DatabaseVersion;
import org.unitarou.yukinoshita.model.db.hsql.HsqldbColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MasterTable
extends AbstractTable {
    private static final HsqldbColumn[] columns_s_ = new HsqldbColumn[]{new HsqldbColumn("MASTER_ID", "INTEGER", 0, "NOT NULL", true), new HsqldbColumn("GAME_TYPE", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("WIDTH", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("HEIGHT", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("FINGERPRINT", "VARBINARY", 676, "NOT NULL")};
    private static final PrimaryKey[] primaryKey_s_ = new PrimaryKey[]{new PrimaryKey("MASTER_ID", 1)};
    private static final ForeignKey[] foreignKeys_s_ = new ForeignKey[0];
    private static final MasterTable instance_s_ = new MasterTable();

    static MasterTable instance() {
        return instance_s_;
    }

    private MasterTable() {
    }

    @Override
    public boolean exists(DatabaseVersion databaseVersion) {
        return true;
    }

    @Override
    public String getTable() {
        return "MASTER";
    }

    @Override
    public PrimaryKey[] getPrimaryKeys(DatabaseVersion databaseVersion) {
        return primaryKey_s_;
    }

    @Override
    public HsqldbColumn[] getColumns(DatabaseVersion databaseVersion) {
        return columns_s_;
    }

    @Override
    protected ForeignKey[] getForeignKeys(DatabaseVersion databaseVersion) {
        return foreignKeys_s_;
    }

    @Override
    protected String getInTableConstraints() {
        return "CONSTRAINT uq1_master UNIQUE (game_type, width, height, fingerprint)";
    }

    @Override
    protected String[] getInterTableConstraintQueries() {
        return new String[0];
    }

    Master selectFromPk(Connection connection, int n) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        Master master = (Master)queryRunner.query(connection, "SELECT master_id, game_type, width, height, fingerprint FROM master WHERE master_id=?", new Object[]{new Integer(n)}, (ResultSetHandler)new UBeanHandler(Master.class));
        return master;
    }

    Master selectFromUnique(Connection connection, RootGameTree rootGameTree, GameType gameType, SgfSize sgfSize) throws SQLException {
        QueryRunner queryRunner = new QueryRunner();
        Master master = (Master)queryRunner.query(connection, "SELECT master_id, game_type, width, height, fingerprint FROM master WHERE game_type=? AND width=? AND height=? AND fingerprint=?", new Object[]{new Integer(gameType.getString()), new Integer(sgfSize.width()), new Integer(sgfSize.height()), Fingerprints.calcFingerprintArray(rootGameTree)}, (ResultSetHandler)new UBeanHandler(Master.class));
        return master;
    }

    private List<Master> selectFromUnique(Connection connection, Object[][] objectArray) throws SQLException {
        UQueryRunner uQueryRunner = new UQueryRunner();
        List<Master> list = uQueryRunner.queryOneRecord(connection, "SELECT master_id, game_type, width, height, fingerprint FROM master WHERE game_type=? AND width=? AND height=? AND fingerprint=?", objectArray, Master.class);
        return list;
    }

    Master insert(Connection connection, RootGameTree rootGameTree) throws SQLException {
        SgfSize sgfSize;
        GameType gameType = rootGameTree.getGameType();
        Master master = this.selectFromUnique(connection, rootGameTree, gameType, sgfSize = rootGameTree.getSize());
        if (master != null) {
            return master;
        }
        QueryRunner queryRunner = new QueryRunner();
        int n = queryRunner.update(connection, "INSERT INTO master (master_id, game_type, width, height, fingerprint) VALUES(null, ?, ?, ?, ?)", new Object[]{new Integer(gameType.getString()), new Integer(sgfSize.width()), new Integer(sgfSize.height()), Fingerprints.calcFingerprintArray(rootGameTree)});
        if (n != 1) {
            throw new SQLException("DB is broken: insert error record:" + n);
        }
        return this.selectFromUnique(connection, rootGameTree, gameType, sgfSize);
    }

    List<Master> insert(Connection connection, List<RootGameTree> list) throws SQLException {
        Object[][] objectArray = this.createParameter(list);
        Object[][] objectArray2 = this.toUnique(objectArray);
        List<Master> list2 = this.selectFromUnique(connection, objectArray2);
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(list.size());
        for (int i = 0; i < objectArray2.length; ++i) {
            if (list2.get(i) != null) continue;
            arrayList.add(objectArray2[i]);
        }
        Object[][] objectArray3 = (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]);
        UQueryRunner uQueryRunner = new UQueryRunner();
        int[] nArray = uQueryRunner.batch(connection, "INSERT INTO master (master_id, game_type, width, height, fingerprint) VALUES(null, ?, ?, ?, ?)", objectArray3);
        for (int n2 : nArray) {
            if (n2 == 1) continue;
            throw new SQLException("DB is broken: insert error record:" + n2);
        }
        Object object = this.selectFromUnique(connection, objectArray3);
        int n = 0;
        for (int i = 0; i < list2.size(); ++i) {
            if (list2.get(i) != null) continue;
            list2.set(i, (Master)object.get(n));
            ++n;
        }
        assert (n == object.size());
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(objectArray2.length);
        for (int n2 = 0; n2 < objectArray2.length; ++n2) {
            hashMap.put(this.makeKey(objectArray2[n2]), new Integer(n2));
        }
        ArrayList<Master> arrayList2 = new ArrayList<Master>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            Integer n3 = (Integer)hashMap.get(this.makeKey(objectArray[i]));
            assert (n3 != null);
            Master master = list2.get(n3);
            assert (master != null);
            arrayList2.add(master);
        }
        return arrayList2;
    }

    private Object[][] createParameter(List<RootGameTree> list) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(list.size());
        for (RootGameTree rootGameTree : list) {
            Object[] objectArray = new Object[]{new Integer(rootGameTree.getGameType().getIntValue()), new Integer(rootGameTree.getSize().width()), new Integer(rootGameTree.getSize().height()), Fingerprints.calcFingerprintArray(rootGameTree)};
            arrayList.add(objectArray);
        }
        return (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]);
    }

    private String makeKey(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder(3000);
        stringBuilder.append((Integer)objectArray[0]).append(':').append((Integer)objectArray[1]).append(':').append((Integer)objectArray[2]).append(':').append(Arrays.toString((byte[])objectArray[3]));
        return stringBuilder.toString();
    }

    private Object[][] toUnique(Object[][] objectArray) {
        HashSet<String> hashSet = new HashSet<String>(objectArray.length);
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(objectArray.length);
        for (Object[] objectArray2 : objectArray) {
            String string = this.makeKey(objectArray2);
            if (hashSet.contains(string)) continue;
            arrayList.add(objectArray2);
            hashSet.add(string);
        }
        return (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]);
    }
}

