/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.unitarou.lang.Strings;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sql.ForeignKey;
import org.unitarou.sql.PrimaryKey;
import org.unitarou.sql.UQueryRunner;
import org.unitarou.yukinoshita.model.db.GameIndex;
import org.unitarou.yukinoshita.model.db.Term;
import org.unitarou.yukinoshita.model.db.TermFrequency;
import org.unitarou.yukinoshita.model.db.hsql.AbstractTable;
import org.unitarou.yukinoshita.model.db.hsql.DatabaseVersion;
import org.unitarou.yukinoshita.model.db.hsql.HsqldbColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermTable
extends AbstractTable {
    private static final HsqldbColumn[] columns_s_ = new HsqldbColumn[]{new HsqldbColumn("TERM_ID", "INTEGER", 0, "NOT NULL", true), new HsqldbColumn("SGF_ID", "CHAR", 2, "NOT NULL"), new HsqldbColumn("GAME_TYPE", "INTEGER", 0, "NOT NULL"), new HsqldbColumn("TERM", "VARCHAR", 0, "NOT NULL")};
    private static final PrimaryKey[] primaryKey_s_ = new PrimaryKey[]{new PrimaryKey("TERM_ID", 1)};
    private static final ForeignKey[] foreignKeys_s_ = new ForeignKey[0];
    private static final TermTable instance_s_ = new TermTable();
    private final Map<String, Reference<Term>> cacheMap_ = new HashMap<String, Reference<Term>>();

    static TermTable instance() {
        return instance_s_;
    }

    private TermTable() {
    }

    @Override
    public boolean exists(DatabaseVersion databaseVersion) {
        return DatabaseVersion.V_2.getVersion() <= databaseVersion.getVersion();
    }

    @Override
    public String getTable() {
        return "TERM";
    }

    @Override
    protected PrimaryKey[] getPrimaryKeys(DatabaseVersion databaseVersion) {
        if (this.exists(databaseVersion)) {
            return primaryKey_s_;
        }
        return PrimaryKey.EMPTY_ARRAY;
    }

    @Override
    protected HsqldbColumn[] getColumns(DatabaseVersion databaseVersion) {
        if (this.exists(databaseVersion)) {
            return columns_s_;
        }
        return HsqldbColumn.EMPTY_ARRAY;
    }

    @Override
    protected ForeignKey[] getForeignKeys(DatabaseVersion databaseVersion) {
        if (this.exists(databaseVersion)) {
            return foreignKeys_s_;
        }
        return ForeignKey.EMPTY_ARRAY;
    }

    @Override
    protected String getInTableConstraints() {
        return "CONSTRAINT uq1_term UNIQUE (sgf_id, game_type, term)";
    }

    @Override
    protected String[] getInterTableConstraintQueries() {
        return Strings.EMPTY_ARRAY;
    }

    List<Term> insertAndSelect(Connection connection, List<Term> list) throws SQLException {
        Object object;
        Object[][] objectArray = new Object[list.size()][3];
        for (int i = 0; i < objectArray.length; ++i) {
            object = list.get(i);
            objectArray[i][0] = ((Term)object).getSgfId();
            objectArray[i][1] = new Integer(((Term)object).getGameType());
            objectArray[i][2] = ((Term)object).getTerm();
        }
        List<Term> list2 = this.select(connection, objectArray);
        object = new TreeMap();
        for (int i = 0; i < list2.size(); ++i) {
            if (list2.get(i) != null) continue;
            object.put(new Integer(i), objectArray[i]);
        }
        Object[][] objectArray2 = (Object[][])object.values().toArray((T[])new Object[object.size()][]);
        UQueryRunner uQueryRunner = new UQueryRunner();
        uQueryRunner.batch(connection, "INSERT INTO term (term_id, sgf_id, game_type, term)VALUES(null, ?, ?, ?)", objectArray2);
        List<Term> list3 = this.select(connection, objectArray2);
        int n = 0;
        for (int i = 0; i < list2.size(); ++i) {
            if (list2.get(i) != null) continue;
            list2.set(i, list3.get(n));
            ++n;
        }
        assert (n == list3.size());
        return list2;
    }

    private List<Term> select(Connection connection, Object[][] objectArray) throws SQLException {
        Reference<Term> reference;
        Object object;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(objectArray.length);
        ArrayList<Term> arrayList2 = new ArrayList<Term>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            Term term;
            object = this.makeKey(objectArray[i]);
            reference = this.cacheMap_.get(object);
            Term term2 = term = reference == null ? null : reference.get();
            if (term == null) {
                arrayList2.add(null);
                arrayList.add(objectArray[i]);
                continue;
            }
            arrayList2.add(new Term(term));
        }
        Object[][] objectArray2 = (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]);
        object = new UQueryRunner();
        reference = ((UQueryRunner)object).queryOneRecord(connection, "SELECT term_id, sgf_id, game_type, term FROM term WHERE sgf_id = ? AND game_type = ? AND term = ?", objectArray2, Term.class);
        int n = 0;
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (arrayList2.get(i) != null) continue;
            Term term = (Term)reference.get(n);
            arrayList2.set(i, term);
            this.cacheMap_.put(this.makeKey(objectArray[i]), new SoftReference<Term>(term));
            ++n;
        }
        return arrayList2;
    }

    private String makeKey(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(objectArray[0]).append(':').append(objectArray[1]).append(':').append(objectArray[2]);
        return stringBuilder.toString();
    }

    List<Term> select(Connection connection, GameIndex gameIndex) throws SQLException {
        UQueryRunner uQueryRunner = new UQueryRunner();
        List<Term> list = uQueryRunner.query(connection, "SELECT t.term_id, t.sgf_id, t.game_type, t.term FROM game_term_map m, term t WHERE t.term_id = m.term_id AND m.file_id = ? AND m.file_order = ?", Term.class, new Integer(gameIndex.getFileId()), new Integer(gameIndex.getFileOrder()));
        return list;
    }

    List<TermFrequency> select(Connection connection, SgfId sgfId, GameType gameType) throws SQLException {
        UQueryRunner uQueryRunner = new UQueryRunner();
        List<TermFrequency> list = uQueryRunner.query(connection, "SELECT t.term_id, t.sgf_id, t.game_type, t.term, COUNT(1) frequency FROM term t INNER JOIN game_term_map m  ON t.term_id = m.term_id WHERE t.sgf_id = ? AND t.game_type = ?GROUP BY t.term_id , t.sgf_id, t.game_type, t.term ORDER BY frequency DESC ", TermFrequency.class, sgfId.id(), new Integer(gameType.getIntValue()));
        return list;
    }
}

