/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.dbutils.QueryRunner;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.parser.SgfParser;
import org.unitarou.sgf.parser.SgfParserException;
import org.unitarou.sql.UQueryRunner;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.TaskMonitor;
import org.unitarou.yukinoshita.model.db.Term;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UpdaterV1ToV2 {
    private static final Message NT_UPGRADE_DATABASE_FROM_V1_TO_V2 = new Message(UpdaterV1ToV2.class, "ntUpgradeDatabaseFromV1ToV2");
    private static final Message NT_TASK_ADD_AND_REMOVE_COLUMNS = new Message(UpdaterV1ToV2.class, "ntTaskAddAndRemoveColumns");
    private static final Message NT_TASK_SELECT_GAME_INFO = new Message(UpdaterV1ToV2.class, "ntTaskSelectGameInfo");
    private static final Message LB_RETRIEVE_TERMS = new Message(UpdaterV1ToV2.class, "lbRetrieveTerms");
    private static final Message LB_UPDATE_GAME_TABLE = new Message(UpdaterV1ToV2.class, "lbUpdateGameTable");
    private static final Message LB_UPDATE_TERM_TABLE = new Message(UpdaterV1ToV2.class, "lbUpdateTermTable");
    private static final Message LB_UPDATE_TERM_TABLE_DETAIL = new Message(UpdaterV1ToV2.class, "lbUpdateTermTableDetail");
    private static final Message LB_LINK_GAME_TO_TERM = new Message(UpdaterV1ToV2.class, "lbLinkGameToTerm");
    private static final Message LB_REMOVE_UNUSED_COLUMN = new Message(UpdaterV1ToV2.class, "lbRemoveUnusedColumn");
    private final DateFormat[] formats_s_ = new DateFormat[]{new SimpleDateFormat("yyyy-mm-dd"), new SimpleDateFormat("yyyy-mm"), new SimpleDateFormat("yyyy")};
    private TaskMonitor monitor_ = TaskMonitor.NULL_OBJECT;
    private SQLException exception_ = null;

    UpdaterV1ToV2() {
    }

    public void setMonitor(TaskMonitor taskMonitor) {
        ArgumentChecker.throwIfNull((Object)taskMonitor);
        this.monitor_ = taskMonitor;
    }

    public TaskMonitor getMonitor() {
        return this.monitor_;
    }

    public SQLException getException() {
        return this.exception_;
    }

    void update(Connection connection) {
        try {
            this.monitor_.start(7, NT_UPGRADE_DATABASE_FROM_V1_TO_V2.get());
            this.updateGameIndexColumn(connection);
            List<GameIndexV1ToV2> list = this.selectGameInfo(connection);
            Map<String, Set<String>> map = this.updateGameInfo(connection, list);
            Map<String, Integer> map2 = this.updateTerm(connection, map);
            this.updateGameTermMap(connection, list, map2);
            this.dropGameInfoColumn(connection);
            this.monitor_.finished();
        }
        catch (SQLException sQLException) {
            this.exception_ = sQLException;
        }
    }

    private void updateGameIndexColumn(Connection connection) throws SQLException {
        this.monitor_.subTaskStated(0, NT_TASK_ADD_AND_REMOVE_COLUMNS.get(), 5);
        QueryRunner queryRunner = new QueryRunner();
        queryRunner.update(connection, "ALTER TABLE game_index DROP COLUMN KEYWORD");
        this.monitor_.subTaskWorked(0, 1, null);
        queryRunner.update(connection, "ALTER TABLE game_index ADD COLUMN game_type INTEGER DEFAULT 1 NOT NULL");
        this.monitor_.subTaskWorked(0, 1, null);
        queryRunner.update(connection, "ALTER TABLE game_index ADD COLUMN move INTEGER DEFAULT 0 NOT NULL");
        this.monitor_.subTaskWorked(0, 1, null);
        queryRunner.update(connection, "ALTER TABLE game_index ADD COLUMN procedure VARCHAR NULL");
        this.monitor_.subTaskWorked(0, 1, null);
        queryRunner.update(connection, "ALTER TABLE game_index ADD COLUMN date VARCHAR NULL");
        this.monitor_.subTaskWorked(0, 1, null);
        this.monitor_.subTaskFinished(0);
    }

    private List<GameIndexV1ToV2> selectGameInfo(Connection connection) throws SQLException {
        this.monitor_.subTaskStated(1, NT_TASK_SELECT_GAME_INFO.get(), -1);
        UQueryRunner uQueryRunner = new UQueryRunner();
        List<GameIndexV1ToV2> list = uQueryRunner.query(connection, "SELECT g.file_id, g.file_order, g.master_id, g.game_info, m.game_type FROM game_index g INNER JOIN master m ON g.master_id = m.master_id", GameIndexV1ToV2.class, new Object[0]);
        this.monitor_.subTaskWorked(1, 1, null);
        this.monitor_.subTaskFinished(1);
        return list;
    }

    private Map<String, Set<String>> updateGameInfo(Connection connection, List<GameIndexV1ToV2> list) throws SQLException {
        Object[][] objectArray;
        Object object;
        this.monitor_.subTaskStated(2, LB_RETRIEVE_TERMS.get(), list.size());
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        for (GameIndexV1ToV2 gameIndexV1ToV2 : list) {
            object = this.parseSequence(gameIndexV1ToV2);
            if (object == null) continue;
            objectArray = ((Sequence)object).getFirst();
            for (Property property : objectArray.getProperties()) {
                String string;
                String string2 = property.getString().trim();
                if (string2.length() == 0) continue;
                if (property.sgfId().equals(SgfId.DATE) && (string = this.parseDate(property)) != null) {
                    gameIndexV1ToV2.setDate(string);
                    continue;
                }
                string = this.makeKey(property.sgfId(), gameIndexV1ToV2.getGameType());
                TreeSet<String> treeSet = (TreeSet<String>)hashMap.get(string);
                if (treeSet == null) {
                    treeSet = new TreeSet<String>();
                    hashMap.put(string, treeSet);
                }
                treeSet.add(string2);
            }
            this.monitor_.subTaskWorked(2, 1, null);
        }
        this.monitor_.subTaskFinished(2);
        this.monitor_.subTaskStated(3, LB_UPDATE_GAME_TABLE.get(), -1);
        int n = 0;
        object = new QueryRunner();
        objectArray = new Object[list.size()][];
        Iterator<GameIndexV1ToV2> iterator = list.iterator();
        while (iterator.hasNext()) {
            GameIndexV1ToV2 gameIndexV1ToV2;
            GameIndexV1ToV2 gameIndexV1ToV22 = gameIndexV1ToV2 = (GameIndexV1ToV2)iterator.next();
            objectArray[n] = new Object[]{new Integer(gameIndexV1ToV22.getGameType()), gameIndexV1ToV22.getDate(), new Integer(gameIndexV1ToV22.getFileId()), new Integer(gameIndexV1ToV22.getFileOrder())};
            ++n;
        }
        this.execBatch((QueryRunner)object, connection, "UPDATE game_index SET game_type = ?, date = ? WHERE file_id = ? AND file_order = ?", objectArray);
        connection.commit();
        this.monitor_.subTaskFinished(3);
        return hashMap;
    }

    private String makeKey(SgfId sgfId, int n) {
        return sgfId.id() + ':' + String.valueOf(n);
    }

    private Sequence parseSequence(GameIndexV1ToV2 gameIndexV1ToV2) {
        Collection collection;
        Object object;
        String string = gameIndexV1ToV2.getGameInfo();
        if (!string.startsWith(String.valueOf('('))) {
            string = '(' + string;
        }
        if (!string.startsWith(String.valueOf(')'))) {
            string = string + ')';
        }
        String string2 = string;
        try {
            object = new SgfParser();
            collection = ((SgfParser)object).parse(string2, Charset.forName("UTF-8"));
        }
        catch (SgfParserException sgfParserException) {
            return null;
        }
        if (collection.size() == 0) {
            return null;
        }
        object = collection.get(0).getSequence();
        if (((Sequence)object).isEmpty()) {
            return null;
        }
        return object;
    }

    private String parseDate(Property property) {
        String string = property.getString().replace('/', '-');
        Date date = null;
        for (DateFormat dateFormat : this.formats_s_) {
            try {
                date = dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (date == null) continue;
            return string;
        }
        return null;
    }

    private Map<String, Integer> updateTerm(Connection connection, Map<String, Set<String>> map) throws SQLException {
        this.monitor_.subTaskStated(4, LB_UPDATE_TERM_TABLE.get(), 1 + map.size());
        UQueryRunner uQueryRunner = new UQueryRunner();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        uQueryRunner.update(connection, "DELETE FROM term;");
        connection.commit();
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            String string = entry.getKey();
            int n = string.indexOf(58);
            String string2 = string.substring(0, n);
            Integer n2 = new Integer(string.substring(n + 1));
            this.monitor_.subTaskWorked(4, 1, LB_UPDATE_TERM_TABLE_DETAIL.get(string2, n2, Integer.toString(entry.getValue().size())));
            Set<String> set = entry.getValue();
            Object[][] objectArray = new Object[set.size()][];
            int n3 = 0;
            for (String string3 : set) {
                objectArray[n3] = new Object[]{string2, n2, string3};
                ++n3;
            }
            uQueryRunner.batch(connection, "INSERT INTO term (term_id, sgf_id, game_type, term)VALUES(null, ?, ?, ?)", objectArray);
            connection.commit();
            List<Term> list = uQueryRunner.query(connection, "SELECT term_id, term FROM term WHERE sgf_id = ? AND game_type = ?", Term.class, string2, n2);
            Iterator object2 = list.iterator();
            while (object2.hasNext()) {
                Term term = (Term)object2.next();
                hashMap.put(string + ':' + term.getTerm(), new Integer(term.getTermId()));
            }
        }
        this.monitor_.subTaskFinished(4);
        return hashMap;
    }

    private void updateGameTermMap(Connection connection, List<GameIndexV1ToV2> list, Map<String, Integer> map) throws SQLException {
        this.monitor_.subTaskStated(5, LB_LINK_GAME_TO_TERM.get(), 1 + list.size());
        QueryRunner queryRunner = new QueryRunner();
        queryRunner.update(connection, "DELETE FROM game_term_map;");
        connection.commit();
        this.monitor_.subTaskWorked(5, 1, null);
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(1100);
        for (GameIndexV1ToV2 gameIndexV1ToV2 : list) {
            Sequence sequence = this.parseSequence(gameIndexV1ToV2);
            if (sequence == null) continue;
            Node node = sequence.getFirst();
            for (Property property : node.getProperties()) {
                String string = this.makeKey(property.sgfId(), gameIndexV1ToV2.getGameType());
                String string2 = property.getString().trim();
                if (string2.length() == 0) continue;
                Number number = map.get(string + ':' + string2);
                if (number == null) {
                    if (property.sgfId().equals(SgfId.DATE)) continue;
                    System.err.println();
                    continue;
                }
                arrayList.add(new Object[]{new Integer(gameIndexV1ToV2.getFileId()), new Integer(gameIndexV1ToV2.getFileOrder()), new Integer(number.intValue())});
            }
            if (10000 < arrayList.size()) {
                this.execBatch(queryRunner, connection, "INSERT INTO game_term_map (file_id, file_order, term_id)VALUES(?, ?, ?)", (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]));
                connection.commit();
                arrayList.clear();
            }
            this.monitor_.subTaskWorked(5, 1, null);
        }
        this.execBatch(queryRunner, connection, "INSERT INTO game_term_map (file_id, file_order, term_id)VALUES(?, ?, ?)", (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]));
        connection.commit();
        this.monitor_.subTaskFinished(5);
    }

    private void dropGameInfoColumn(Connection connection) throws SQLException {
        this.monitor_.subTaskStated(6, LB_REMOVE_UNUSED_COLUMN.get(), -1);
        QueryRunner queryRunner = new QueryRunner();
        queryRunner.update(connection, "ALTER TABLE game_index DROP COLUMN game_info");
        this.monitor_.subTaskFinished(6);
    }

    private void execBatch(QueryRunner queryRunner, Connection connection, String string, Object[][] objectArray) throws SQLException {
        for (int i = 0; i <= (objectArray.length - 1) / 1000; ++i) {
            int n = i * 1000;
            int n2 = Math.min(n + 1000, objectArray.length);
            Object[][] objectArray2 = new Object[n2 - n][];
            System.arraycopy(objectArray, n, objectArray2, 0, objectArray2.length);
            queryRunner.batch(connection, string, objectArray2);
        }
    }

    public static class GameIndexV1ToV2 {
        private int fileId_;
        private int fileOrder_;
        private int masterId_;
        private int gameType_;
        private String gameInfo_;
        private String keyword_;
        private String date_;

        public int getFileId() {
            return this.fileId_;
        }

        public void setFileId(int n) {
            this.fileId_ = n;
        }

        public int getFileOrder() {
            return this.fileOrder_;
        }

        public void setFileOrder(int n) {
            this.fileOrder_ = n;
        }

        public String getGameInfo() {
            return this.gameInfo_;
        }

        public void setGameInfo(String string) {
            this.gameInfo_ = string;
        }

        public String getKeyword() {
            return this.keyword_;
        }

        public void setKeyword(String string) {
            this.keyword_ = string;
        }

        public int getMasterId() {
            return this.masterId_;
        }

        public void setMasterId(int n) {
            this.masterId_ = n;
        }

        public String getDate() {
            return this.date_;
        }

        public void setDate(String string) {
            this.date_ = string;
        }

        public int getGameType() {
            return this.gameType_;
        }

        public void setGameType(int n) {
            this.gameType_ = n;
        }
    }
}

