/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.ml.Message;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.jface.JFaceContext;
import org.unitarou.yukinoshita.view.jface.JFaceWindow;
import org.unitarou.yukinoshita.view.jface.pref.BoardPainterPreferencePage;
import org.unitarou.yukinoshita.view.jface.pref.BoardPreferencePage;
import org.unitarou.yukinoshita.view.jface.pref.DatabasePreferencePage;
import org.unitarou.yukinoshita.view.jface.pref.FilePreferencePage;
import org.unitarou.yukinoshita.view.jface.pref.ProblemPreferencePage;
import org.unitarou.yukinoshita.view.jface.pref.SgfFormatterPreferencePage;
import org.unitarou.yukinoshita.view.jface.pref.SgfParserPreferencePage;
import org.unitarou.yukinoshita.view.jface.pref.SoundEffectPreferencePage;

public class OpenPreferenceAction
extends Action {
    private static final Message CLB_NAME = new Message(OpenPreferenceAction.class, "clbName");
    private static final Message LB_DIALOG_TITLE = new Message(OpenPreferenceAction.class, "lbDialogTitle");
    private final JFaceContext context_;

    public OpenPreferenceAction(JFaceContext jFaceContext) {
        ArgumentChecker.throwIfNull((Object)jFaceContext);
        this.setText(CLB_NAME.get());
        this.setEnabled(true);
        this.context_ = jFaceContext;
    }

    public void run() {
        PreferenceManager preferenceManager = new PreferenceManager();
        preferenceManager.addToRoot(BoardPreferencePage.createPreferenceNode("BOARD"));
        preferenceManager.addTo("BOARD", BoardPainterPreferencePage.createPreferenceNode());
        preferenceManager.addToRoot(ProblemPreferencePage.createPreferenceNode());
        preferenceManager.addToRoot(DatabasePreferencePage.createPreferenceNode());
        preferenceManager.addToRoot(FilePreferencePage.createPreferenceNode("FILE"));
        preferenceManager.addTo("FILE", SgfParserPreferencePage.createPreferenceNode());
        preferenceManager.addTo("FILE", SgfFormatterPreferencePage.createPreferenceNode());
        preferenceManager.addToRoot(SoundEffectPreferencePage.createPreferenceNode());
        PreferenceDialog preferenceDialog = new PreferenceDialog(null, preferenceManager);
        preferenceDialog.setPreferenceStore(this.context_.getPreferenceStore());
        preferenceDialog.create();
        Shell shell = preferenceDialog.getShell();
        shell.setText(LB_DIALOG_TITLE.get());
        shell.setImages(JFaceWindow.getAppIcons());
        preferenceDialog.open();
    }
}

