/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ann;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.unitarou.lang.Strings;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.ann.AnnotationPanel;
import org.unitarou.yukinoshita.view.jface.ann.RealEditor;
import org.unitarou.yukinoshita.view.jface.ann.ResultEditor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameAnnotationPanel
extends AnnotationPanel {
    private static final SgfId[] TYPE_SIMPLE_TEXT = new SgfId[]{SgfId.GAME_NAME, SgfId.PLAYER_WHITE, SgfId.WHITE_RANK, SgfId.WHITE_TEAM, SgfId.PLAYER_BLACK, SgfId.BLACK_RANK, SgfId.BLACK_TEAM, SgfId.DATE, SgfId.EVENT, SgfId.ROUND, SgfId.PLACE, SgfId.RULE, SgfId.OVERTIME, SgfId.USER, SgfId.SOURCE, SgfId.COPYRIGHT, SgfId.ANNOTATION, SgfId.OPENING};
    private static final SgfId[] TYPE_SPINNER = new SgfId[]{SgfId.HANDICAP, SgfId.KOMI, SgfId.TIMELIMIT};
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private GameType gameType_;
    private ScrolledComposite scFrame_;
    private final Map<SgfId, Object> widgetMap_;
    private final Adapter adapter_;
    private final TextListener textListener_;
    private final SpinnerModifyListened spinnerModifyListened_;
    private final ResultModifyListened resultModifyListened_;
    private NodeView nodeView_;
    private boolean isEditMode_;

    public GameAnnotationPanel(GameType gameType) {
        this.gameType_ = gameType;
        ArgumentChecker.throwIfNull((Object)gameType);
        this.widgetMap_ = new HashMap<SgfId, Object>();
        this.adapter_ = new Adapter();
        this.textListener_ = new TextListener();
        this.spinnerModifyListened_ = new SpinnerModifyListened();
        this.resultModifyListened_ = new ResultModifyListened();
        this.isEditMode_ = false;
    }

    @Override
    protected EventBroker getEventBroker() {
        return this.eventBroker_;
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        this.scFrame_ = new ScrolledComposite(composite, 512);
        this.scFrame_.setExpandHorizontal(true);
        this.scFrame_.setExpandVertical(false);
        this.scFrame_.getVerticalBar().setIncrement(10);
        Composite composite2 = this.gameType_.equals(GameType.PROBLEM) ? this.createProblemContents(this.scFrame_) : (this.gameType_.equals(GameType.DRILL) ? this.createDrillContents(this.scFrame_) : this.createGameContents(this.scFrame_));
        composite2.pack();
        this.scFrame_.setContent(composite2);
        this.scFrame_.setMinSize(composite2.getSize());
        this.adapter_.setEditMode(this.isEditMode_);
        this.updateImpl(this.nodeView_);
        return this.scFrame_;
    }

    @Override
    public void close() {
    }

    private Composite createGameContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout(2, false));
        this.createSimpleTextEditor(composite2, SgfId.GAME_NAME);
        this.createTextEditor(composite2, SgfId.GAME_COMMENT);
        this.createSimpleTextEditor(composite2, SgfId.PLAYER_WHITE);
        this.createSimpleTextEditor(composite2, SgfId.WHITE_RANK);
        this.createSimpleTextEditor(composite2, SgfId.WHITE_TEAM);
        this.createSimpleTextEditor(composite2, SgfId.PLAYER_BLACK);
        this.createSimpleTextEditor(composite2, SgfId.BLACK_RANK);
        this.createSimpleTextEditor(composite2, SgfId.BLACK_TEAM);
        this.createHandicapEditor(composite2);
        this.createResultEditor(composite2);
        this.createSimpleTextEditor(composite2, SgfId.DATE);
        this.createSimpleTextEditor(composite2, SgfId.EVENT);
        this.createSimpleTextEditor(composite2, SgfId.ROUND);
        this.createSimpleTextEditor(composite2, SgfId.PLACE);
        this.createSimpleTextEditor(composite2, SgfId.RULE);
        this.createReal(composite2, SgfId.TIMELIMIT, 0, 99999999, 0, 1, 60);
        this.createSimpleTextEditor(composite2, SgfId.OVERTIME);
        this.createSimpleTextEditor(composite2, SgfId.USER);
        this.createSimpleTextEditor(composite2, SgfId.SOURCE);
        this.createSimpleTextEditor(composite2, SgfId.COPYRIGHT);
        this.createSimpleTextEditor(composite2, SgfId.ANNOTATION);
        this.createSimpleTextEditor(composite2, SgfId.OPENING);
        return composite2;
    }

    private Composite createProblemContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout(2, false));
        this.createSimpleTextEditor(composite2, SgfId.GAME_NAME);
        this.createResultEditor(composite2);
        this.createSimpleTextEditor(composite2, SgfId.BLACK_RANK);
        this.createReal(composite2, SgfId.TIMELIMIT, 0, 99999999, 0, 1, 60);
        this.createTextEditor(composite2, SgfId.GAME_COMMENT);
        this.createSimpleTextEditor(composite2, SgfId.DATE);
        this.createSimpleTextEditor(composite2, SgfId.SOURCE);
        this.createSimpleTextEditor(composite2, SgfId.USER);
        this.createSimpleTextEditor(composite2, SgfId.COPYRIGHT);
        return composite2;
    }

    private Composite createDrillContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout(2, false));
        this.createSimpleTextEditor(composite2, SgfId.GAME_NAME);
        this.createSimpleTextEditor(composite2, SgfId.BLACK_RANK);
        this.createTextEditor(composite2, SgfId.GAME_COMMENT);
        return composite2;
    }

    private Text createSimpleTextEditor(Composite composite, SgfId sgfId) {
        Label label = new Label(composite, 131072);
        label.setText(sgfId.displayName());
        GridData gridData = new GridData(0x1000008, 0x1000000, false, false);
        label.setLayoutData(gridData);
        Text text = new Text(composite, 2052);
        gridData = new GridData(4, 4, true, true);
        text.setLayoutData(gridData);
        text.addFocusListener(this.textListener_);
        text.addModifyListener(this.textListener_);
        text.setData(sgfId);
        this.widgetMap_.put(sgfId, text);
        return text;
    }

    private void createTextEditor(Composite composite, SgfId sgfId) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, true, 2, 5);
        composite2.setLayoutData(gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 5;
        composite2.setLayout(gridLayout);
        Label label = new Label(composite2, 131072);
        label.setText(sgfId.displayName());
        gridData = new GridData(1, 1, false, false);
        label.setLayoutData(gridData);
        Text text = new Text(composite2, 2626);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = label.computeSize((int)-1, (int)-1).y * 10;
        text.setLayoutData(gridData);
        text.addFocusListener(this.textListener_);
        text.addModifyListener(this.textListener_);
        text.setData(sgfId);
        this.widgetMap_.put(sgfId, text);
    }

    private void createReal(Composite composite, SgfId sgfId, int n, int n2, int n3, int n4, int n5) {
        Label label = new Label(composite, 131072);
        label.setText(sgfId.displayName());
        GridData gridData = new GridData(3, 2, false, false);
        label.setLayoutData(gridData);
        RealEditor realEditor = new RealEditor(sgfId, n, n2, n3, n4, n5);
        Control control = realEditor.createContents(composite);
        gridData = new GridData(4, 4, true, true);
        control.setLayoutData(gridData);
        realEditor.addModifyListener(this.spinnerModifyListened_);
        this.widgetMap_.put(sgfId, realEditor);
    }

    private void createHandicapEditor(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData(gridData);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout(gridLayout);
        this.createReal(composite2, SgfId.HANDICAP, 0, 99, 0, 1, 5);
        this.createReal(composite2, SgfId.KOMI, -999, 999, 1, 5, 10);
    }

    private void createResultEditor(Composite composite) {
        ResultEditor resultEditor = new ResultEditor();
        Control control = resultEditor.createContents(composite);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        control.setLayoutData(gridData);
        resultEditor.addModifyListener(this.resultModifyListened_);
        this.widgetMap_.put(SgfId.RESULT, resultEditor);
    }

    @Override
    public Control getControl() {
        return this.scFrame_;
    }

    private void updateImpl(NodeView nodeView) {
        if (this.scFrame_ == null || nodeView == null) {
            return;
        }
        this.setModelUpdateMode(true);
        this.updateText(nodeView);
        this.updateSimpleTexts(nodeView);
        this.updateSpinner(nodeView);
        this.updateResult(nodeView);
        this.setModelUpdateMode(false);
    }

    private void updateText(NodeView nodeView) {
        SgfId[] sgfIdArray = new SgfId[]{SgfId.GAME_COMMENT};
        for (int i = 0; i < sgfIdArray.length; ++i) {
            Text text = (Text)this.widgetMap_.get(sgfIdArray[i]);
            if (text == null) continue;
            Property property = nodeView.findProperty(sgfIdArray[i]);
            String string = "";
            if (property != null) {
                string = property.getString();
            }
            if (string.equals(text.getText())) continue;
            text.setText(string);
        }
    }

    private void updateSimpleTexts(NodeView nodeView) {
        for (int i = 0; i < TYPE_SIMPLE_TEXT.length; ++i) {
            Text text = (Text)this.widgetMap_.get(TYPE_SIMPLE_TEXT[i]);
            if (text == null) continue;
            Property property = nodeView.findProperty(TYPE_SIMPLE_TEXT[i]);
            String string = "";
            if (property != null) {
                string = property.getString();
            }
            if (string.equals(text.getText())) continue;
            text.setText(string);
        }
    }

    private void updateSpinner(NodeView nodeView) {
        for (SgfId sgfId : TYPE_SPINNER) {
            Property property;
            RealEditor realEditor = (RealEditor)this.widgetMap_.get(sgfId);
            if (realEditor == null || (property = nodeView.findProperty(sgfId)) == null) continue;
            realEditor.setProperty(property);
        }
    }

    private void updateResult(NodeView nodeView) {
        ResultEditor resultEditor = (ResultEditor)this.widgetMap_.get(SgfId.RESULT);
        if (resultEditor != null) {
            resultEditor.setProperty(nodeView.findProperty(SgfId.RESULT));
        }
    }

    private class Adapter
    implements GameMonitor,
    GameInfoNodeMonitor,
    ControllerStatusMonitor,
    EventBrokerMonitor {
        private boolean panelIsShown_ = true;

        private Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            GameAnnotationPanel.this.eventBroker_.removeView(GameAnnotationPanel.this);
            GameAnnotationPanel.this.eventBroker_ = eventBroker;
            GameAnnotationPanel.this.eventBroker_.addView(GameAnnotationPanel.this);
        }

        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            this.panelIsShown_ = gameMediator.getGameType().equals(GameAnnotationPanel.this.gameType_);
            if (!this.panelIsShown_) {
                return;
            }
            NodeView nodeView = gameMediator.getCurrentNodeView();
            GameAnnotationPanel.this.nodeView_ = nodeView;
            GameAnnotationPanel.this.updateImpl(GameAnnotationPanel.this.nodeView_);
        }

        public void gameInfoChanged(NodeView nodeView) {
            if (!this.panelIsShown_) {
                return;
            }
            GameAnnotationPanel.this.nodeView_ = nodeView;
            GameAnnotationPanel.this.updateImpl(GameAnnotationPanel.this.nodeView_);
        }

        public void setEditMode(boolean bl) {
            Text text;
            GameAnnotationPanel.this.isEditMode_ = bl;
            for (int i = 0; i < TYPE_SIMPLE_TEXT.length; ++i) {
                Text text2 = (Text)GameAnnotationPanel.this.widgetMap_.get(TYPE_SIMPLE_TEXT[i]);
                if (text2 == null) continue;
                text2.setEditable(GameAnnotationPanel.this.isEditMode_);
            }
            for (SgfId sgfId : TYPE_SPINNER) {
                RealEditor realEditor = (RealEditor)GameAnnotationPanel.this.widgetMap_.get(sgfId);
                if (realEditor == null) continue;
                realEditor.setEditable(GameAnnotationPanel.this.isEditMode_);
            }
            ResultEditor resultEditor = (ResultEditor)GameAnnotationPanel.this.widgetMap_.get(SgfId.RESULT);
            if (resultEditor != null) {
                resultEditor.setEditable(GameAnnotationPanel.this.isEditMode_);
            }
            if ((text = (Text)GameAnnotationPanel.this.widgetMap_.get(SgfId.GAME_COMMENT)) != null) {
                text.setEditable(GameAnnotationPanel.this.isEditMode_);
            }
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }
    }

    private class ResultModifyListened
    implements ModifyListener {
        private ResultModifyListened() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            if (!GameAnnotationPanel.this.isEditMode_) {
                return;
            }
            ResultEditor resultEditor = (ResultEditor)GameAnnotationPanel.this.widgetMap_.get(SgfId.RESULT);
            String string = resultEditor.getDatum();
            GameAnnotationPanel.this.updateProperty(string, SgfId.RESULT, GameAnnotationPanel.this.nodeView_);
        }
    }

    private class SpinnerModifyListened
    implements ModifyListener {
        private SpinnerModifyListened() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            if (!GameAnnotationPanel.this.isEditMode_) {
                return;
            }
            RealEditor realEditor = (RealEditor)modifyEvent.data;
            String string = realEditor.getDatum();
            SgfId sgfId = realEditor.getSgfId();
            GameAnnotationPanel.this.updateProperty(string, sgfId, GameAnnotationPanel.this.nodeView_);
        }
    }

    private class TextListener
    extends FocusAdapter
    implements ModifyListener {
        private final Map<Text, String> lastStringMap_ = new HashMap<Text, String>();

        private TextListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            String string;
            int n;
            Text text = (Text)modifyEvent.widget;
            String string2 = this.lastStringMap_.get(text);
            if (string2 == null) {
                string2 = "";
            }
            if ((n = Yukinoshita.context(null).getInteger(Context.CHAR_LENGTH_PER_UPDATE)) <= Strings.calcDiffSize(string2, string = text.getText())) {
                this.update(text);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            this.update((Text)focusEvent.widget);
        }

        private void update(Text text) {
            if (!GameAnnotationPanel.this.isEditMode_) {
                return;
            }
            String string = text.getText();
            SgfId sgfId = (SgfId)text.getData();
            GameAnnotationPanel.this.updateProperty(string, sgfId, GameAnnotationPanel.this.nodeView_);
            this.lastStringMap_.put(text, string);
        }
    }
}

