/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ann;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.unitarou.ml.Message;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.yukinoshita.view.jface.ann.Editor;
import org.unitarou.yukinoshita.view.jface.ann.RootAnnotationPanel;

class SizeEditor
extends Editor {
    private static final Message CLB_SIZE_HEIGHT = new Message(RootAnnotationPanel.class, "clbSizeHeight");
    private static final Message CLB_SIZE_WIDTH = new Message(RootAnnotationPanel.class, "clbSizeWidth");
    private Composite frame_;
    private StackLayout stackLayout_;
    private Composite advancedPanel_;
    private Composite normalPanel_;
    private Combo cbSize_;
    private Combo cbHorizontalSize_;
    private Combo cbVerticalSize_;
    private boolean enableAdvanced_ = false;
    private final ComboFocusLost comboFocusLost_ = new ComboFocusLost();

    SizeEditor() {
    }

    void setAdvanced(boolean bl) {
        this.enableAdvanced_ = bl;
        this.stackLayout_.topControl = this.enableAdvanced_ ? this.advancedPanel_ : this.normalPanel_;
        this.stackLayout_.topControl.getParent().layout();
    }

    public Control createContents(Composite composite) {
        this.frame_ = new Composite(composite, 0);
        this.stackLayout_ = new StackLayout();
        this.frame_.setLayout(this.stackLayout_);
        this.normalPanel_ = this.createNormalEditor(this.frame_);
        this.advancedPanel_ = this.createAdvancedEditor(this.frame_);
        this.stackLayout_.topControl = this.normalPanel_;
        return this.frame_;
    }

    public Control getControl() {
        return this.frame_;
    }

    private Composite createNormalEditor(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new FillLayout());
        this.cbSize_ = new Combo(composite2, 12);
        for (int i = 1; i <= SgfSize.MAX.height(); ++i) {
            String string = String.valueOf(i);
            this.cbSize_.add(string + 'x' + string);
        }
        this.cbSize_.select(SgfSize.DEFAULT.height() - 1);
        this.cbSize_.addFocusListener(this.comboFocusLost_);
        this.cbSize_.setData(SgfId.SIZE);
        return composite2;
    }

    private Composite createAdvancedEditor(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout(gridLayout);
        Label label = new Label(composite2, 131072);
        label.setText(CLB_SIZE_HEIGHT.get());
        label.setLayoutData(new GridData(128));
        this.cbVerticalSize_ = this.createSizeCombo(composite2);
        this.cbVerticalSize_.addFocusListener(this.comboFocusLost_);
        label = new Label(composite2, 131072);
        label.setText(CLB_SIZE_WIDTH.get());
        label.setLayoutData(new GridData(128));
        this.cbHorizontalSize_ = this.createSizeCombo(composite2);
        this.cbHorizontalSize_.addFocusListener(this.comboFocusLost_);
        return composite2;
    }

    public void close() {
    }

    private Combo createSizeCombo(Composite composite) {
        Combo combo = new Combo(composite, 12);
        combo.setLayoutData(new GridData(768));
        for (int i = 1; i <= SgfSize.MAX.height(); ++i) {
            combo.add(String.valueOf(i));
        }
        combo.select(SgfSize.DEFAULT.height() - 1);
        combo.setData(SgfId.SIZE);
        return combo;
    }

    void select(SgfSize sgfSize) {
        this.cbHorizontalSize_.select(sgfSize.width() - 1);
        this.cbVerticalSize_.select(sgfSize.height() - 1);
        this.cbSize_.select(sgfSize.height() - 1);
    }

    void setEditable(boolean bl) {
        this.cbSize_.setEnabled(bl);
        this.cbHorizontalSize_.setEnabled(bl);
        this.cbVerticalSize_.setEnabled(bl);
    }

    String getDatum() {
        if (this.enableAdvanced_) {
            int n = this.cbVerticalSize_.getSelectionIndex() + 1;
            int n2 = this.cbHorizontalSize_.getSelectionIndex() + 1;
            return SgfSize.create(n2, n).getString();
        }
        int n = this.cbSize_.getSelectionIndex() + 1;
        return SgfSize.create(n, n).getString();
    }

    private class ComboFocusLost
    extends FocusAdapter {
        private ComboFocusLost() {
        }

        public void focusLost(FocusEvent focusEvent) {
            SizeEditor.this.fireModifyText(focusEvent.widget);
        }
    }
}

