/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import java.util.EnumSet;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.cmd.ChangeProblemCommand;
import org.unitarou.yukinoshita.view.cmd.MoveInProblemCommand;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolveEventDelegator
implements EventDelegator,
Adaptable {
    private ProblemStatus problemStatus_ = ProblemStatus.SOLVE;
    private ProblemStatusMonitor monitor_ = new ProblemStatusMonitor(){

        public void update(ProblemStatus problemStatus) {
            SolveEventDelegator.this.problemStatus_ = problemStatus;
        }
    };

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.monitor_.getClass())) {
            return this.monitor_;
        }
        return null;
    }

    @Override
    public void resetStatus() {
        this.problemStatus_ = ProblemStatus.SOLVE;
    }

    @Override
    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus);
        BlockSituation blockSituation = new BlockSituation();
        if (!this.isValidMovePoint(blockStatus, nodeView)) {
            return blockSituation;
        }
        blockSituation.setCursor(CanvasCursor.MOVE.get(nodeView.getNextMoveColor()));
        blockSituation.setTransientProperty(nodeView.getNextMoveColor().moveType().makeProperty(blockStatus.getPoint()));
        return blockSituation;
    }

    @Override
    public boolean executeEvent(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent, (Object)eventBroker);
        if (!this.isValidMovePoint(blockStatus, nodeView)) {
            return false;
        }
        SgfPoint sgfPoint = blockStatus.getPoint();
        eventBroker.addView(this);
        eventBroker.executeCommand(new MoveInProblemCommand(sgfPoint, this.problemStatus_));
        eventBroker.removeView(this);
        return true;
    }

    private boolean isValidMovePoint(BlockStatus blockStatus, NodeView nodeView) {
        EnumSet<SgfPointType> enumSet = blockStatus.getPointTypes();
        return enumSet.contains((Object)SgfPointType.EMPTY) && !enumSet.contains((Object)SgfPointType.FORBIDDEN) && blockStatus.getPoint() != null && nodeView.getNextMoveColor() != null;
    }

    @Override
    public void keyPressed(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
        int n = keyEvent.keyCode | keyEvent.stateMask;
        if (n == 110) {
            eventBroker.executeCommand(new ChangeProblemCommand(1));
        } else if (n == 112) {
            eventBroker.executeCommand(new ChangeProblemCommand(-1));
        } else if (n == 103) {
            eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.ANSWER));
        }
    }

    @Override
    public void keyReleased(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
    }
}

