/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.AddVariation;
import org.unitarou.yukinoshita.view.cmd.NodeJumpCommand;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

class VariationEventDelegator
implements EventDelegator {
    private SgfColor selectedColor_ = SgfColor.BLACK;

    public void resetStatus() {
        this.selectedColor_ = SgfColor.BLACK;
    }

    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent) {
        Enum enum_;
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus);
        BlockSituation blockSituation = new BlockSituation();
        if (nodeView.isChildrenStyle() && nodeView.isLast()) {
            return blockSituation;
        }
        SgfPoint sgfPoint = blockStatus.getPoint();
        if (sgfPoint == null) {
            sgfPoint = SgfPoint.createPass(nodeView.getSize());
        } else {
            enum_ = nodeView.getPointTypes4Variation(blockStatus.getPoint());
            if (enum_.equals((Object)SgfPointType.FORBIDDEN)) {
                return blockSituation;
            }
        }
        enum_ = nodeView.getOppositeColor();
        blockSituation.setCursor(CanvasCursor.VARIATION.get((SgfColor)enum_));
        if (enum_ == null) {
            enum_ = this.selectedColor_;
        }
        Property property = ((SgfColor)enum_).moveType().makeProperty(sgfPoint);
        blockSituation.setTransientProperty(property);
        return blockSituation;
    }

    public boolean executeEvent(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        Object object;
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent, (Object)eventBroker);
        if (mouseEvent.button != 1) {
            return false;
        }
        if (nodeView.isChildrenStyle() && nodeView.isLast()) {
            return false;
        }
        if (blockStatus.getPoint() != null && ((Enum)(object = nodeView.getPointTypes4Variation(blockStatus.getPoint()))).equals((Object)SgfPointType.FORBIDDEN)) {
            return false;
        }
        object = blockStatus.getPoint();
        if (object == null) {
            object = SgfPoint.createPass(nodeView.getSize());
        }
        if (nodeView.isChildrenStyle()) {
            SgfColor sgfColor = nodeView.getNextMoveColor();
            if (sgfColor == null) {
                sgfColor = this.selectedColor_;
            }
            eventBroker.executeCommand(new AddVariation(sgfColor, (SgfPoint)object));
        } else {
            SgfColor sgfColor = nodeView.getMove().getColor();
            if (sgfColor == null) {
                sgfColor = this.selectedColor_;
            }
            eventBroker.executeCommand(new NodeJumpCommand(-1));
            eventBroker.executeCommand(new AddVariation(sgfColor, (SgfPoint)object));
        }
        eventBroker.executeCommand(new NodeJumpCommand(1));
        return true;
    }

    public void keyPressed(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
        int n = keyEvent.keyCode | keyEvent.stateMask;
        switch (n) {
            case 131072: {
                this.selectedColor_ = this.selectedColor_.opposite();
                break;
            }
            case 262144: {
                this.selectedColor_ = this.selectedColor_.opposite();
            }
        }
    }

    public void keyReleased(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
    }
}

