/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.sp;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.jface.ColorResource;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.Stone;
import org.unitarou.swt.AlphaBlender;
import org.unitarou.swt.Rectangles;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainterParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStonePainter
implements StonePainter {
    protected static final ColorResource COLOR_TRANSPARENT = new ColorResource(0, 255, 255);
    private Point boxSize_ = new Point(0, 0);
    private ImageData[] blackStones_ = new ImageData[0];
    private ImageData[] blackTransitStones_ = new ImageData[0];
    private ImageData[] whiteStones_ = new ImageData[0];
    private ImageData[] whiteTransitStones_ = new ImageData[0];
    private final Set<SgfPoint> lastBlacks_ = new HashSet<SgfPoint>();
    private final Set<SgfPoint> lastWhites_ = new HashSet<SgfPoint>();
    private final Set<SgfPoint> lastCaptured_ = new HashSet<SgfPoint>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void paintStone(GC gC, Rectangle rectangle, StonePainterParameter stonePainterParameter) {
        ImageData imageData;
        ImageData imageData2;
        ArgumentChecker.throwIfNull((Object)gC, (Object)rectangle, (Object)stonePainterParameter);
        Rectangle rectangle2 = Rectangles.createScaled(rectangle, 0.95);
        this.checkAndCreateStones(Geometry.getSize(rectangle2));
        Image image = null;
        if (SgfColor.WHITE.equals(stonePainterParameter.getSgfColor())) {
            imageData2 = this.selectByPoint(rectangle, this.whiteTransitStones_);
            imageData = this.selectByPoint(rectangle, this.whiteStones_);
        } else if (SgfColor.BLACK.equals(stonePainterParameter.getSgfColor())) {
            imageData2 = this.selectByPoint(rectangle, this.blackTransitStones_);
            imageData = this.selectByPoint(rectangle, this.blackStones_);
        } else {
            return;
        }
        try {
            image = stonePainterParameter.isTransient() ? new Image(null, imageData2) : new Image(null, imageData);
            gC.drawImage(image, rectangle2.x, rectangle2.y);
        }
        finally {
            if (image != null) {
                image.dispose();
            }
        }
        String string = stonePainterParameter.getLabel();
        if (string != null && !"".equals(string)) {
            this.paintLabel(gC, rectangle2, stonePainterParameter.getLabel(), stonePainterParameter.getSgfColor(), stonePainterParameter.isLastMove());
        } else if (stonePainterParameter.isLastMove()) {
            this.paintLastMoveMark(gC, rectangle2, stonePainterParameter.getSgfColor());
        }
    }

    private void checkAndCreateStones(Point point) {
        int n;
        if (point.equals(this.boxSize_)) {
            return;
        }
        this.boxSize_ = point;
        this.whiteStones_ = this.createWhiteStone(this.boxSize_);
        this.whiteTransitStones_ = new ImageData[this.whiteStones_.length];
        for (n = 0; n < this.whiteTransitStones_.length; ++n) {
            this.whiteTransitStones_[n] = AlphaBlender.createTransparent(this.whiteStones_[n], 170);
        }
        this.blackStones_ = this.createBlackStone(this.boxSize_);
        this.blackTransitStones_ = new ImageData[this.blackStones_.length];
        for (n = 0; n < this.blackTransitStones_.length; ++n) {
            this.blackTransitStones_[n] = AlphaBlender.createTransparent(this.blackStones_[n], 170);
        }
    }

    private ImageData selectByPoint(Rectangle rectangle, ImageData[] imageDataArray) {
        Point point = new Point(rectangle.x / rectangle.width, rectangle.y / rectangle.height);
        int n = (point.x + point.y * 2) % imageDataArray.length;
        return imageDataArray[n];
    }

    protected abstract ImageData[] createWhiteStone(Point var1);

    protected abstract ImageData[] createBlackStone(Point var1);

    protected abstract void paintLabel(GC var1, Rectangle var2, String var3, SgfColor var4, boolean var5);

    protected abstract void paintLastMoveMark(GC var1, Rectangle var2, SgfColor var3);

    @Override
    public Set<SgfPoint> getDurablePaintings(NodeView nodeView) {
        ArgumentChecker.throwIfNull((Object)nodeView);
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
        SortedSet<SgfPoint> sortedSet = nodeView.getIgoBoard().position(SgfColor.BLACK);
        SortedSet<SgfPoint> sortedSet2 = nodeView.getIgoBoard().position(SgfColor.WHITE);
        TreeSet<SgfPoint> treeSet = new TreeSet<SgfPoint>();
        for (Stone stone : nodeView.getCaptured(SgfColor.WHITE)) {
            if (!stone.isValid()) continue;
            treeSet.add(stone.getPoint());
        }
        for (Stone stone : nodeView.getCaptured(SgfColor.BLACK)) {
            if (!stone.isValid()) continue;
            treeSet.add(stone.getPoint());
        }
        HashSet hashSet2 = new HashSet();
        this.addUpdateSet(hashSet, this.lastCaptured_, treeSet, hashSet2);
        this.addUpdateSet(hashSet, this.lastBlacks_, sortedSet, hashSet2);
        this.addUpdateSet(hashSet, this.lastWhites_, sortedSet2, hashSet2);
        return hashSet;
    }

    private void addUpdateSet(Set<SgfPoint> set, Set<SgfPoint> set2, Set<SgfPoint> set3, Set<SgfPoint> set4) {
        set4.clear();
        set4.addAll(set2);
        set4.addAll(set3);
        set2.retainAll(set3);
        set4.removeAll(set2);
        set2.clear();
        set2.addAll(set3);
        set.addAll(set4);
    }

    @Override
    public Set<SgfPoint> getTransientPaintings(NodeView nodeView) {
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>(1);
        if (nodeView.getMove().getPoint() != null) {
            hashSet.add(nodeView.getMove().getPoint());
        }
        return hashSet;
    }
}

