/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.unitarou.ml.BasicMessages;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.Result;
import org.unitarou.swt.UTable;
import org.unitarou.swt.UTableProvider;
import org.unitarou.yukinoshita.DatabaseManager;
import org.unitarou.yukinoshita.model.db.Term;
import org.unitarou.yukinoshita.model.db.TermFrequency;
import org.unitarou.yukinoshita.view.jface.db.ColumnType;
import org.unitarou.yukinoshita.view.jface.db.FilterPanel;
import org.unitarou.yukinoshita.view.jface.db.TermSheet;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultTermSheet
extends TermSheet {
    private Composite frame_;
    private Text txPattern_;
    private final UTable<TermFrequency> utTerm_ = new UTable<TermFrequency>(new TableProvider(), 65538);
    private ColumnType type_;
    private final List<TermFrequency> termList_ = new ArrayList<TermFrequency>();

    public DefaultTermSheet() {
        this.type_ = ColumnType.SGF_EVENT;
    }

    @Override
    public void close() {
    }

    @Override
    protected List<Term> getSelected() {
        List<TermFrequency> list = this.utTerm_.getRecords();
        Table table = this.utTerm_.getControl();
        ArrayList<Term> arrayList = new ArrayList<Term>(table.getSelectionCount());
        for (TableItem tableItem : table.getSelection()) {
            int n = table.indexOf(tableItem);
            TermFrequency termFrequency = list.get(n);
            if (termFrequency.getSgfId() == null) continue;
            arrayList.add(termFrequency);
        }
        return arrayList;
    }

    @Override
    public Control createContents(Composite composite) {
        this.frame_ = new Composite(composite, 0);
        this.frame_.setLayout(SwtFactory.createThinInnerGrid(1, true));
        Control control = this.createTermPatternFilterPart(this.frame_);
        control.setLayoutData(new GridData(4, 128, true, false));
        Table table = this.utTerm_.createContents(this.frame_);
        table.setLayoutData(new GridData(4, 4, true, true));
        table.setLinesVisible(true);
        this.utTerm_.getControl().addSelectionListener(new ListenerImpl());
        return this.frame_;
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    private Control createTermPatternFilterPart(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(SwtFactory.createThinInnerGrid(2, false));
        Label label = new Label(composite2, 16384);
        label.setText(BasicMessages.LB_FILTER.get());
        label.setLayoutData(new GridData(16384, 0x1000000, false, false));
        this.txPattern_ = new Text(composite2, 2048);
        this.txPattern_.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.txPattern_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                DefaultTermSheet.this.filter();
            }
        });
        return composite2;
    }

    private void filter() {
        String string = this.txPattern_.getText();
        if (string.length() == 0) {
            this.utTerm_.clear();
            this.utTerm_.addAll(this.termList_);
            return;
        }
        ArrayList<TermFrequency> arrayList = new ArrayList<TermFrequency>(this.termList_.size());
        for (TermFrequency termFrequency : this.termList_) {
            if (termFrequency.getTerm() == null || termFrequency.getTerm().indexOf(string) == -1) continue;
            arrayList.add(termFrequency);
        }
        this.utTerm_.clear();
        this.utTerm_.addAll(arrayList);
    }

    @Override
    void updateContents(GameType gameType, ColumnType columnType) {
        this.type_ = columnType;
        this.termList_.clear();
        this.termList_.add(new TermFrequency());
        this.termList_.addAll(DatabaseManager.instance().searchTermFrequency(columnType.getSgfId(), gameType));
        this.utTerm_.clear();
        this.utTerm_.addAll(this.termList_);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TableProvider
    implements UTableProvider<TermFrequency> {
        private TableProvider() {
        }

        @Override
        public int compareTo(TermFrequency termFrequency, TermFrequency termFrequency2, int n) {
            if (termFrequency.getSgfId() == null) {
                return -1;
            }
            if (termFrequency2.getSgfId() == null) {
                return 1;
            }
            switch (n) {
                case 0: {
                    return termFrequency.getFrequency() - termFrequency2.getFrequency();
                }
                case 1: {
                    if (DefaultTermSheet.this.type_.equals((Object)ColumnType.SGF_RESULT)) {
                        return Result.parse(termFrequency.getTerm()).compareTo(Result.parse(termFrequency2.getTerm()));
                    }
                    return termFrequency.getTerm().compareTo(termFrequency2.getTerm());
                }
            }
            return 0;
        }

        @Override
        public int getColumnSize() {
            return 2;
        }

        @Override
        public boolean[] getSotableColums() {
            return new boolean[]{true, true};
        }

        @Override
        public void setup(TableColumn[] tableColumnArray) {
            tableColumnArray[0].setText(BasicMessages.LB_COUNT.get());
            tableColumnArray[0].setMoveable(false);
            tableColumnArray[1].setText(DefaultTermSheet.this.type_.toString());
            tableColumnArray[1].setMoveable(false);
        }

        @Override
        public void set(TableItem tableItem, TermFrequency termFrequency) {
            if (termFrequency.getSgfId() == null) {
                tableItem.setText(0, "");
                tableItem.setText(1, BasicMessages.LB_NO_CHOICE.get());
            } else {
                tableItem.setText(0, String.valueOf(termFrequency.getFrequency()));
                tableItem.setText(1, termFrequency.getTerm());
            }
            int n = tableItem.getParent().indexOf(tableItem);
            tableItem.setBackground(SwtFactory.getZebraColor(n));
        }
    }

    private class ListenerImpl
    extends SelectionAdapter {
        private ListenerImpl() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            for (FilterPanel.Listener listener : DefaultTermSheet.this.getListeners()) {
                listener.filterChanged();
            }
        }
    }
}

