/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.unitarou.jface.ColorResource;
import org.unitarou.lang.Objects;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.Result;
import org.unitarou.swt.UTableProvider;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.DatabaseManager;
import org.unitarou.yukinoshita.model.db.GameTerm;
import org.unitarou.yukinoshita.model.db.Term;
import org.unitarou.yukinoshita.view.jface.db.ColumnType;
import org.unitarou.yukinoshita.view.jface.db.TiSearchedFile;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameTableProvider
implements UTableProvider<TiSearchedFile> {
    private static final ColorResource CL_ROWNUM = new ColorResource(22);
    private static final int IDX_CHECK = 0;
    private static final int IDX_ROWNUM = 1;
    private static final int IDX_CT_OFFSET = 2;
    private final GameType gameType_;
    private final List<ColumnType> columnTypes_;
    private final Map<SgfId, Map<String, GameTerm>> orderedTermMap_;

    public GameTableProvider(GameType gameType, List<ColumnType> list) {
        ArgumentChecker.throwIfNull((Object)gameType, list);
        this.gameType_ = gameType;
        this.columnTypes_ = new ArrayList<ColumnType>(list);
        this.orderedTermMap_ = new HashMap<SgfId, Map<String, GameTerm>>();
    }

    @Override
    public int getColumnSize() {
        return this.columnTypes_.size() + 2;
    }

    @Override
    public void setup(TableColumn[] tableColumnArray) {
        tableColumnArray[1].setText(ColumnType.FILE_INDEX.toString());
        tableColumnArray[1].setAlignment(131072);
        for (int i = 2; i < tableColumnArray.length; ++i) {
            ColumnType columnType = this.columnTypes_.get(i - 2);
            tableColumnArray[i].setText(columnType.toString());
            tableColumnArray[i].setMoveable(true);
        }
        int[] nArray = new int[tableColumnArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        nArray[0] = 1;
        nArray[1] = 0;
        tableColumnArray[0].getParent().setColumnOrder(nArray);
    }

    @Override
    public boolean[] getSotableColums() {
        boolean[] blArray = new boolean[this.columnTypes_.size() + 2];
        Arrays.fill(blArray, true);
        blArray[1] = false;
        return blArray;
    }

    @Override
    public int compareTo(TiSearchedFile tiSearchedFile, TiSearchedFile tiSearchedFile2, int n) {
        if (n == 0) {
            return tiSearchedFile.isChecked() == tiSearchedFile2.isChecked() ? 0 : (tiSearchedFile.isChecked() ? 1 : -1);
        }
        if (n == 1) {
            return 0;
        }
        ColumnType columnType = this.columnTypes_.get(n - 2);
        if (columnType.getSgfId() != null) {
            Map<String, GameTerm> map = this.orderedTermMap_.get(columnType.getSgfId());
            if (map == null) {
                map = this.selectGameTerm(columnType.getSgfId());
                this.orderedTermMap_.put(columnType.getSgfId(), map);
            }
            String string = this.makeKey(tiSearchedFile.getFileId(), tiSearchedFile.getFileOrder());
            String string2 = this.makeKey(tiSearchedFile2.getFileId(), tiSearchedFile2.getFileOrder());
            GameTerm gameTerm = map.get(string);
            GameTerm gameTerm2 = map.get(string2);
            if (gameTerm == null) {
                return gameTerm2 == null ? 0 : 1;
            }
            if (gameTerm2 == null) {
                return -1;
            }
            if (columnType.equals((Object)ColumnType.SGF_RESULT)) {
                return Result.parse(gameTerm.getTerm()).compareTo(Result.parse(gameTerm2.getTerm()));
            }
            return Objects.compateIncludeNull(gameTerm.getTerm(), gameTerm2.getTerm());
        }
        switch (columnType) {
            case PATH: {
                return tiSearchedFile.getPath().compareTo(tiSearchedFile2.getPath());
            }
            case FILE_NAME: {
                String string = FilenameUtils.getName(tiSearchedFile.getPath());
                String string3 = FilenameUtils.getName(tiSearchedFile2.getPath());
                return string.compareTo(string3);
            }
            case FOLDER: {
                String string = FilenameUtils.getFullPath(tiSearchedFile.getPath());
                String string4 = FilenameUtils.getFullPath(tiSearchedFile2.getPath());
                return string.compareTo(string4);
            }
            case MOVES: {
                return tiSearchedFile.getMove() - tiSearchedFile2.getMove();
            }
            case DATE: {
                String string = tiSearchedFile.getDate();
                String string5 = tiSearchedFile2.getDate();
                return Objects.compateIncludeNull(string, string5);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, GameTerm> selectGameTerm(SgfId sgfId) {
        Shell shell = Display.getCurrent().getActiveShell();
        shell.setCursor(shell.getDisplay().getSystemCursor(1));
        try {
            List<GameTerm> list = DatabaseManager.instance().selectGameTerm(this.gameType_, sgfId);
            HashMap<String, GameTerm> hashMap = new HashMap<String, GameTerm>(list.size());
            for (GameTerm gameTerm : list) {
                hashMap.put(this.makeKey(gameTerm.getFileId(), gameTerm.getFileOrder()), gameTerm);
            }
            HashMap<String, GameTerm> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            shell.setCursor(null);
        }
    }

    private String makeKey(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n).append(':').append(n2);
        return stringBuilder.toString();
    }

    @Override
    public void set(TableItem tableItem, TiSearchedFile tiSearchedFile) {
        int n;
        List<Term> list = tiSearchedFile.getTerm();
        if (list == null) {
            list = DatabaseManager.instance().select(tiSearchedFile.getGameIndex());
            tiSearchedFile.setTerm(list);
        }
        for (n = 0; n < this.columnTypes_.size(); ++n) {
            ColumnType columnType = this.columnTypes_.get(n);
            String string = columnType.getString(tiSearchedFile, list);
            tableItem.setText(n + 2, string);
        }
        tableItem.setText(0, "");
        tableItem.setChecked(tiSearchedFile.isChecked());
        n = tableItem.getParent().indexOf(tableItem);
        tableItem.setText(1, Integer.toString(n + 1));
        tableItem.setBackground(SwtFactory.getZebraColor(n));
        tableItem.setBackground(1, CL_ROWNUM.get());
    }
}

