/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg.fe;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.MouseEvent;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.CanvasHookedStateHandler;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBoardEditorStateHandler
extends CanvasHookedStateHandler {
    private static final Log log_s_ = LogFactory.getLog(QueryBoardEditorStateHandler.class);
    private final Adapter adapter_;

    public QueryBoardEditorStateHandler(IgoBoardPanel igoBoardPanel, Map<HandlerPhase, EventDelegator> map) {
        super(igoBoardPanel);
        ArgumentChecker.throwIfNull(map);
        if (map.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.adapter_ = new Adapter();
        for (Map.Entry<HandlerPhase, EventDelegator> entry : map.entrySet()) {
            this.registerDelegator(entry.getKey(), entry.getValue());
        }
        this.setHandlerPhase(map.keySet().iterator().next());
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    private class Adapter
    implements ControllerStatusMonitor {
        private HandlerPhase currentHandlerPhase_;

        private Adapter() {
        }

        public void setEditMode(boolean bl) {
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
            ArgumentChecker.throwIfNull((Object)handlerPhase);
            if (handlerPhase.equals(this.currentHandlerPhase_)) {
                return;
            }
            if (QueryBoardEditorStateHandler.this.findDelegator(handlerPhase) == null) {
                log_s_.warn("Unknown HandlerStatus, use " + HandlerPhase.SELECT + " insted. status=" + handlerPhase);
                handlerPhase = HandlerPhase.SETUP;
            }
            QueryBoardEditorStateHandler.this.setHandlerPhase(handlerPhase);
            QueryBoardEditorStateHandler.this.getEventDelegator().resetStatus();
            MouseEvent mouseEvent = QueryBoardEditorStateHandler.this.getMouseEvent();
            if (mouseEvent != null) {
                BlockSituation blockSituation = QueryBoardEditorStateHandler.this.getEventDelegator().getBlockSituation(QueryBoardEditorStateHandler.this.getIgoBoardPanel().getNodeView(), QueryBoardEditorStateHandler.this.getBlockStatus(), mouseEvent);
                QueryBoardEditorStateHandler.this.getIgoBoardPanel().getCanvas().setCursor(blockSituation.getCursor());
            }
            this.currentHandlerPhase_ = handlerPhase;
        }
    }
}

