/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gm;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.unitarou.ml.Message;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.swt.TableColumnMessage;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.DatabaseManager;
import org.unitarou.yukinoshita.model.db.Score;

public class ProblemScoreTableHandler {
    private static final TableColumnMessage[] DEF_COLUMNS = new TableColumnMessage[]{new TableColumnMessage(ProblemScoreTableHandler.class, "date", 131072), new TableColumnMessage(ProblemScoreTableHandler.class, "result", 16384), new TableColumnMessage(ProblemScoreTableHandler.class, "limit", 131072), new TableColumnMessage(ProblemScoreTableHandler.class, "elapse", 131072)};
    private static final Message FMT_TIME = new Message(ProblemScoreTableHandler.class, "fmtTime");
    private static final Message FMT_RESULT = new Message(ProblemScoreTableHandler.class, "fmtResult");
    private final Table table_;
    private final SetDataListener setDataListener_;
    private final MouseWheelListener mouseWheelListener_;
    private RootGameTree rgt_;
    private Score[] scores_;

    public ProblemScoreTableHandler(Table table) {
        ArgumentChecker.throwIfNull((Object)table);
        this.table_ = table;
        this.setDataListener_ = new SetDataListener();
        this.mouseWheelListener_ = new MouseWheelListener();
        this.rgt_ = new RootGameTree();
        this.scores_ = new Score[0];
        this.createTable();
        this.updateRows();
    }

    private void createTable() {
        this.table_.setHeaderVisible(true);
        this.table_.setLinesVisible(true);
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>(DEF_COLUMNS.length);
        for (TableColumnMessage tableColumnMessage : DEF_COLUMNS) {
            TableColumn tableColumn = new TableColumn(this.table_, 16384);
            tableColumnMessage.setup(tableColumn);
            arrayList.add(tableColumn);
        }
        TableItem tableItem = new TableItem(this.table_, 16384);
        tableItem.setText(0, FMT_TIME.get((Object)new Date()));
        tableItem.setText(1, FMT_RESULT.get((Object)new Integer(1)));
        tableItem.setText(2, String.valueOf(999));
        tableItem.setText(3, String.valueOf(999));
        for (TableColumn tableColumn : arrayList) {
            tableColumn.pack();
        }
        this.table_.setItemCount(0);
        this.table_.addListener(36, this.setDataListener_);
        this.table_.addListener(37, this.mouseWheelListener_);
        this.table_.addMouseTrackListener(this.mouseWheelListener_);
    }

    private void updateRows() {
        this.scores_ = DatabaseManager.instance().selectScore(this.rgt_);
        this.table_.setItemCount(this.scores_.length);
        this.table_.setSelection(this.scores_.length - 1);
        Event event = new Event();
        event.widget = this.table_;
        this.table_.notifyListeners(13, event);
    }

    public void update(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        this.rgt_ = rootGameTree;
        this.table_.setItemCount(0);
        this.updateRows();
    }

    public Score getScore(int n) {
        if (n < 0 || this.table_.getItemCount() <= n) {
            throw new IllegalArgumentException();
        }
        return this.scores_[n];
    }

    private class MouseWheelListener
    extends MouseTrackAdapter
    implements Listener {
        private MouseWheelListener() {
        }

        public void handleEvent(Event event) {
            ProblemScoreTableHandler.this.table_.getVerticalBar().setThumb(1);
            int n = ProblemScoreTableHandler.this.table_.getSelectionIndex();
            if (n < 0) {
                return;
            }
            if (0 < event.count) {
                if ((n -= event.count / 3) < 0) {
                    n = 0;
                }
            } else if (event.count < 0 && ProblemScoreTableHandler.this.table_.getItemCount() <= (n -= event.count / 3)) {
                n = ProblemScoreTableHandler.this.table_.getItemCount() - 1;
            }
            if (ProblemScoreTableHandler.this.table_.getSelectionIndex() != n) {
                ProblemScoreTableHandler.this.table_.setSelection(n);
                Event event2 = new Event();
                event2.widget = ProblemScoreTableHandler.this.table_;
                ProblemScoreTableHandler.this.table_.notifyListeners(13, event2);
            }
        }

        public void mouseEnter(MouseEvent mouseEvent) {
            if (ProblemScoreTableHandler.this.table_.getShell() == Display.getCurrent().getActiveShell()) {
                ProblemScoreTableHandler.this.table_.forceFocus();
            }
        }
    }

    private class SetDataListener
    implements Listener {
        private SetDataListener() {
        }

        public void handleEvent(Event event) {
            TableItem tableItem = (TableItem)event.item;
            int n = ProblemScoreTableHandler.this.table_.indexOf(tableItem);
            Score score = ProblemScoreTableHandler.this.scores_[n];
            tableItem.setText(0, FMT_TIME.get((Object)score.getExamined()));
            tableItem.setText(1, FMT_RESULT.get((Object)new Integer(score.getResult())));
            tableItem.setText(2, String.valueOf(score.getTimeLimit()));
            tableItem.setText(3, String.valueOf(score.getElapsed()));
        }
    }
}

