/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gm;

import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.unitarou.io.Ios;
import org.unitarou.jface.ColorResource;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.parser.SgfParser;
import org.unitarou.sgf.parser.SgfParserException;
import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.USashForm;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.db.Score;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.YukinoshitaPanel;
import org.unitarou.yukinoshita.view.jface.board.DigestIgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.gm.ProblemScoreTableHandler;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.OutlineMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScorePanel
implements YukinoshitaPanel {
    private static final Message LB_NOT_IN_SERVICE = new Message(ScorePanel.class, "lbNotInService");
    private static ColorResource notInServiceFontColor = new ColorResource(18);
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private final Adapter adapter_ = new Adapter();
    private RootGameTree rgt_ = new RootGameTree();
    private boolean showable_;
    private Composite frame_ = null;
    private StackLayout stackLayout_ = null;
    private Control problemScore_ = null;
    private ProblemScoreTableHandler tableHandler_ = null;
    private final DigestIgoBoardPanel digestPanel_ = new DigestIgoBoardPanel(true, true);
    private Control notInService_ = null;

    @Override
    public void close() {
        Ios.closeQuietly(this.digestPanel_);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    @Override
    public Control createContents(Composite composite) {
        this.frame_ = new Composite(composite, 0);
        this.stackLayout_ = new StackLayout();
        this.frame_.setLayout(this.stackLayout_);
        this.setTopControl();
        return this.frame_;
    }

    private void setTopControl() {
        if (this.frame_ == null) {
            return;
        }
        if (GameType.PROBLEM == this.rgt_.getGameType() && this.showable_) {
            this.stackLayout_.topControl = this.getProblemScorePanel();
            this.tableHandler_.update(this.rgt_);
        } else {
            this.stackLayout_.topControl = this.getNotInServicePanel();
        }
        this.frame_.layout();
    }

    private Control getProblemScorePanel() {
        if (this.problemScore_ != null) {
            return this.problemScore_;
        }
        USashForm uSashForm = SwtFactory.createUSashForm(this.frame_, 512);
        Table table = new Table(uSashForm, 0x10010004);
        table.addSelectionListener(this.adapter_);
        this.tableHandler_ = new ProblemScoreTableHandler(table);
        this.digestPanel_.createContents(uSashForm);
        uSashForm.setWeights(new int[]{1, -200});
        this.problemScore_ = uSashForm;
        return this.problemScore_;
    }

    private Control getNotInServicePanel() {
        if (this.notInService_ != null) {
            return this.notInService_;
        }
        Composite composite = new Composite(this.frame_, 0);
        composite.setLayout(new GridLayout());
        Label label = new Label(composite, 16448);
        label.setText(LB_NOT_IN_SERVICE.get());
        label.setForeground(notInServiceFontColor.get());
        label.setLayoutData(new GridData(0x1000000, 0x1000000, true, true));
        this.notInService_ = composite;
        return this.notInService_;
    }

    private class Adapter
    extends SelectionAdapter
    implements EventBrokerMonitor,
    GameMonitor,
    ControllerStatusMonitor,
    OutlineMonitor {
        private Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            ScorePanel.this.eventBroker_.removeView(ScorePanel.this);
            ScorePanel.this.eventBroker_ = eventBroker;
            ScorePanel.this.eventBroker_.addView(ScorePanel.this);
        }

        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            ScorePanel.this.rgt_ = gameMediator.getRootGameTree();
            ScorePanel.this.setTopControl();
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
            ScorePanel.this.showable_ = HandlerPhase.SOLVE != handlerPhase;
            ScorePanel.this.setTopControl();
        }

        public void setEditMode(boolean bl) {
            ScorePanel.this.showable_ = ScorePanel.this.showable_ || bl;
            ScorePanel.this.setTopControl();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Collection collection;
            Table table = (Table)selectionEvent.widget;
            int n = table.getSelectionIndex();
            if (n < 0) {
                RootGameTree rootGameTree = new RootGameTree();
                rootGameTree.getSequence().addFirst(new Node());
                ScorePanel.this.digestPanel_.updateImage(rootGameTree);
                return;
            }
            Score score = ScorePanel.this.tableHandler_.getScore(n);
            SgfParser sgfParser = new SgfParser();
            try {
                collection = sgfParser.parse(score.getMoves());
            }
            catch (SgfParserException sgfParserException) {
                sgfParserException.printStackTrace();
                return;
            }
            ScorePanel.this.digestPanel_.updateImage(collection.get(0));
        }

        public void show(Collection[] collectionArray) {
            ScorePanel.this.rgt_ = new RootGameTree();
            ScorePanel.this.setTopControl();
        }

        public void setFocus(Collection collection) {
            ScorePanel.this.rgt_ = new RootGameTree();
            ScorePanel.this.setTopControl();
        }

        public void setFocus(RootGameTree rootGameTree) {
            ArgumentChecker.throwIfNull((Object)rootGameTree);
            ScorePanel.this.rgt_ = rootGameTree;
            ScorePanel.this.setTopControl();
        }
    }
}

