/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.util;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.unitarou.jface.ColorResource;
import org.unitarou.swt.USashForm;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.context.CurrentContext;

public class SwtFactory {
    private static final ContextValue<RGB> CL_ZEBRA_1 = new ContextValue<RGB>(SwtFactory.class, "clZebra1", new RGB(255, 255, 255));
    private static final ContextValue<RGB> CL_ZEBRA_2 = new ContextValue<RGB>(SwtFactory.class, "clZebra2", new RGB(221, 255, 221));

    public static USashForm createUSashForm(Composite composite, int n) {
        ArgumentChecker.throwIfNull((Object)composite);
        USashForm uSashForm = new USashForm(composite, n | 0x10000);
        uSashForm.setSashWidth(5);
        return uSashForm;
    }

    public static Group createGroup(Composite composite, int n) {
        ArgumentChecker.throwIfNull((Object)composite);
        Group group = new Group(composite, n | 0x10);
        return group;
    }

    public static Button createCheckButton(Composite composite, int n) {
        ArgumentChecker.throwIfNull((Object)composite);
        Button button = new Button(composite, n | 0x20 | 0x800000);
        return button;
    }

    public static Button createRadioButton(Composite composite, int n) {
        ArgumentChecker.throwIfNull((Object)composite);
        Button button = new Button(composite, n | 0x10 | 0x800000);
        return button;
    }

    public static GridLayout createGrid(int n, boolean bl) {
        GridLayout gridLayout = new GridLayout(n, bl);
        gridLayout.marginWidth = 4;
        gridLayout.marginHeight = 4;
        gridLayout.horizontalSpacing = 4;
        gridLayout.verticalSpacing = 4;
        return gridLayout;
    }

    public static GridLayout createInnerGrid(int n, boolean bl) {
        GridLayout gridLayout = new GridLayout(n, bl);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 4;
        gridLayout.verticalSpacing = 4;
        return gridLayout;
    }

    public static GridLayout createThinGrid(int n, boolean bl) {
        GridLayout gridLayout = new GridLayout(n, bl);
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 2;
        return gridLayout;
    }

    public static GridLayout createThinInnerGrid(int n, boolean bl) {
        GridLayout gridLayout = new GridLayout(n, bl);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 2;
        return gridLayout;
    }

    public static Color getZebraColor(int n) {
        CurrentContext currentContext = Yukinoshita.context(null);
        RGB rGB = n % 2 == 0 ? currentContext.getAttribute(CL_ZEBRA_1) : currentContext.getAttribute(CL_ZEBRA_2);
        return ColorResource.get(rGB);
    }

    protected SwtFactory() {
    }
}

