/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.wizard.pc;

import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.unitarou.io.Ios;
import org.unitarou.ml.Message;
import org.unitarou.sgf.util.pc.ProblemType;
import org.unitarou.swt.FolderPanel;
import org.unitarou.swt.ProgressPanel;
import org.unitarou.swt.UTable;
import org.unitarou.swt.UTableProvider;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.SimpleTaskListener;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;
import org.unitarou.yukinoshita.view.jface.wizard.pc.RootGameTreeRecord;
import org.unitarou.yukinoshita.view.jface.wizard.pc.TaskConfig;
import org.unitarou.yukinoshita.view.jface.wizard.pc.TaskRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertingWizardPage
extends WizardPage {
    private static final Log log_s_ = LogFactory.getLog(ConvertingWizardPage.class);
    private static final ContextValue<File> DES_FOLDER = new ContextValue<File>(ConvertingWizardPage.class, "desFolder", Ios.getCurrentDirectory());
    private static final Message LB_SRC_FOLDER = new Message(ConvertingWizardPage.class, "lbSrcFolder");
    private static final Message LB_DES_FOLDER = new Message(ConvertingWizardPage.class, "lbDesFolder");
    private static final Message NT_DLG_SPECIFY_FOLDER = new Message(ConvertingWizardPage.class, "ntDlgSpecifyFolder");
    private static final Message MSG_DLG_SPECIFY_FOLDER = new Message(ConvertingWizardPage.class, "msgDlgSpecifyFolder");
    private static final Message LB_APPEND_TYPES = new Message(ConvertingWizardPage.class, "lbAppendTypes");
    private static final Message LB_CONFIG = new Message(ConvertingWizardPage.class, "lbConfig");
    private static final Message CLB_CONVERT = new Message(ConvertingWizardPage.class, "clbConvert");
    private static final Message MSG_CANT_APPEND_TYPES_BY_CONFIG = new Message(ConvertingWizardPage.class, "msgCantAppendTypesByConfig");
    private static final Message MSG_SPECIFY_DES_FOLDER = new Message(ConvertingWizardPage.class, "msgSpecifyDesFolder");
    private static final Message MSG_SPECIFY_NORMAL_FOLDER = new Message(ConvertingWizardPage.class, "msgSpecifyNormalFolder");
    private static final Message LB_TABLE_STATUS = new Message(ConvertingWizardPage.class, "lbTableStatus");
    private static final Message LB_TABLE_TYPE = new Message(ConvertingWizardPage.class, "lbTableType");
    private static final Message LB_TABLE_FILE_NAME = new Message(ConvertingWizardPage.class, "lbTableFileName");
    private static final Message LB_TABLE_INDEX = new Message(ConvertingWizardPage.class, "lbTableIndex");
    private static final Message MSG_ABORT_WIZARD = new Message(ConvertingWizardPage.class, "msgAbortWizard");
    private static final Message MSG_FINISH_WIZARD = new Message(ConvertingWizardPage.class, "msgFinishWizard");
    private static final Message MSG_SPECIFY_ANOTHER_HIERARCHY = new Message(ConvertingWizardPage.class, "msgSpecifyAnotherHierarchy");
    private static final Message MSG_START_CONVERTING = new Message(ConvertingWizardPage.class, "msgStartConverting");
    private File srcRoot_ = Ios.getCurrentDirectory();
    private List<RootGameTreeRecord> srcRecords_;
    private Label lbSourceRoot_ = null;
    private final UTable<RootGameTreeRecord> table_ = new UTable<RootGameTreeRecord>(new LabelProvider(), 65536);
    private final FolderPanel folderPanel_ = new FolderPanel();
    private Button btStart_;
    private final ProgressPanel progressPanel_;
    private final Map<TaskConfig, Button> configButtonMap_;

    public ConvertingWizardPage() {
        super("convertingWizardPage");
        this.folderPanel_.setLabelText(LB_DES_FOLDER.get());
        File file = Yukinoshita.context(null).getAttribute(DES_FOLDER);
        this.folderPanel_.setup(NT_DLG_SPECIFY_FOLDER.get(), MSG_DLG_SPECIFY_FOLDER.get(), file);
        this.progressPanel_ = new ProgressPanel();
        this.configButtonMap_ = new HashMap<TaskConfig, Button>();
        this.setPageComplete(false);
    }

    @Override
    public void createControl(Composite composite) {
        Button button;
        ProblemType problemType;
        Object object2;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(SwtFactory.createThinInnerGrid(1, false));
        this.lbSourceRoot_ = new Label(composite2, 16384);
        this.lbSourceRoot_.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.table_.createContents(composite2);
        Table table = this.table_.getControl();
        table.setLinesVisible(true);
        table.setLayoutData(new GridData(4, 4, true, true));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData(new GridData(4, 0x1000000, true, false));
        composite3.setLayout(SwtFactory.createThinGrid(2, false));
        Group group = SwtFactory.createGroup(composite3, 0);
        group.setLayout(new FillLayout(512));
        group.setLayoutData(new GridData(16384, 128, false, false));
        group.setText(LB_APPEND_TYPES.get());
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Button button = (Button)selectionEvent.widget;
                TaskConfig taskConfig = (TaskConfig)((Object)button.getData());
                ConvertingWizardPage.this.updateSetting(taskConfig, button.getSelection());
            }
        };
        for (Object object2 : EnumSet.allOf(TaskConfig.class)) {
            problemType = object2.getProblemType();
            if (problemType == null) continue;
            button = new Button(group, 32);
            button.setText(problemType.toString());
            button.setData(object2);
            button.setSelection(object2.isDefault());
            button.addSelectionListener(selectionAdapter);
            this.configButtonMap_.put((TaskConfig)((Object)object2), button);
        }
        group = SwtFactory.createGroup(composite3, 0);
        group.setLayout(new FillLayout(512));
        group.setLayoutData(new GridData(16384, 128, false, false));
        group.setText(LB_CONFIG.get());
        for (Object object2 : EnumSet.allOf(TaskConfig.class)) {
            problemType = object2.getProblemType();
            if (problemType != null) continue;
            button = new Button(group, 32);
            button.setText(object2.toString());
            button.setData(object2);
            button.setSelection(object2.isDefault());
            button.addSelectionListener(selectionAdapter);
            this.configButtonMap_.put((TaskConfig)((Object)object2), button);
        }
        Control control = this.folderPanel_.createContents(composite2);
        control.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.folderPanel_.getText().setEditable(false);
        this.folderPanel_.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ConvertingWizardPage.this.checkPageComplete();
            }
        });
        object2 = this.createProgressFrame(composite2);
        ((Control)object2).setLayoutData(new GridData(4, 0x1000000, true, false));
        this.updateSetting(null, false);
        this.setControl(composite2);
        this.setMessage(MSG_SPECIFY_DES_FOLDER.get());
    }

    private Composite createProgressFrame(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(SwtFactory.createThinInnerGrid(2, false));
        Composite composite3 = this.progressPanel_.createContents(composite2);
        composite3.setLayoutData(new GridData(4, 4, true, true));
        this.btStart_ = new Button(composite2, 8);
        this.btStart_.setLayoutData(new GridData(16384, 1024, false, false));
        this.btStart_.setEnabled(false);
        this.btStart_.setText(CLB_CONVERT.get());
        this.btStart_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConvertingWizardPage.this.startUpdate();
            }
        });
        return composite2;
    }

    private void startUpdate() {
        this.btStart_.setEnabled(false);
        EnumSet<TaskConfig> enumSet = EnumSet.noneOf(TaskConfig.class);
        for (TaskConfig taskConfig : EnumSet.allOf(TaskConfig.class)) {
            if (!this.configButtonMap_.get((Object)taskConfig).getSelection()) continue;
            enumSet.add(taskConfig);
        }
        TaskRunner taskRunner = new TaskRunner(this.srcRoot_, this.folderPanel_.getFolder(), this.table_.getRecords(), enumSet, new TaskListenerImpl());
        new Thread(taskRunner).start();
    }

    public void setRecords(File file, List<RootGameTreeRecord> list) {
        ArgumentChecker.throwIfNull((Object)file, list);
        this.srcRoot_ = file;
        this.lbSourceRoot_.setText(LB_SRC_FOLDER.get((Object)this.srcRoot_.getAbsolutePath()));
        this.progressPanel_.setStatus("", 0);
        this.srcRecords_ = list;
        this.copySourceRecords();
        this.checkPageComplete();
    }

    private void copySourceRecords() {
        ArrayList<RootGameTreeRecord> arrayList = new ArrayList<RootGameTreeRecord>(this.srcRecords_.size());
        for (RootGameTreeRecord rootGameTreeRecord : this.srcRecords_) {
            arrayList.add(new RootGameTreeRecord(rootGameTreeRecord));
        }
        this.table_.clear();
        this.table_.addAll(arrayList);
    }

    private void updateSetting(TaskConfig taskConfig, boolean bl) {
        Object object2;
        EnumSet<TaskConfig> enumSet = EnumSet.noneOf(TaskConfig.class);
        for (Object object2 : EnumSet.allOf(TaskConfig.class)) {
            Button button = this.configButtonMap_.get(object2);
            if (!button.getSelection()) continue;
            enumSet.add((TaskConfig)((Object)object2));
        }
        EnumSet<TaskConfig> enumSet2 = TaskConfig.canonicalize(enumSet);
        object2 = TaskConfig.enableSet(enumSet2);
        for (TaskConfig taskConfig2 : EnumSet.allOf(TaskConfig.class)) {
            Button button = this.configButtonMap_.get((Object)taskConfig2);
            button.setSelection(enumSet2.contains((Object)taskConfig2));
            button.setEnabled(((AbstractCollection)object2).contains((Object)taskConfig2));
        }
        if (enumSet2.equals(enumSet)) {
            this.checkPageComplete();
            return;
        }
        if (bl && TaskConfig.REMOVE_OTHER_TYPES.equals((Object)taskConfig)) {
            this.setMessage(MSG_CANT_APPEND_TYPES_BY_CONFIG.get(), 1);
        }
    }

    private void checkPageComplete() {
        CurrentContext currentContext = Yukinoshita.context(null);
        currentContext.setAttribute(DES_FOLDER, this.folderPanel_.getStartFolder());
        File file = this.folderPanel_.getFolder();
        if (file == null) {
            this.setMessage(MSG_SPECIFY_DES_FOLDER.get());
            this.setErrorMessage(null);
            this.btStart_.setEnabled(false);
            this.setPageComplete(false);
            return;
        }
        if (!Ios.isNormalDirectory(file)) {
            this.setErrorMessage(MSG_SPECIFY_NORMAL_FOLDER.get());
            this.btStart_.setEnabled(false);
            this.setPageComplete(false);
            return;
        }
        if (Ios.isChild(this.srcRoot_, file) || Ios.isChild(file, this.srcRoot_)) {
            this.setErrorMessage(MSG_SPECIFY_ANOTHER_HIERARCHY.get());
            this.btStart_.setEnabled(false);
            this.setPageComplete(false);
            return;
        }
        if (!this.btStart_.getEnabled()) {
            this.copySourceRecords();
            this.setMessage(MSG_START_CONVERTING.get());
            this.setErrorMessage(null);
            this.btStart_.setEnabled(true);
            this.setPageComplete(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LabelProvider
    implements UTableProvider<RootGameTreeRecord> {
        private LabelProvider() {
        }

        @Override
        public int getColumnSize() {
            return 4;
        }

        @Override
        public boolean[] getSotableColums() {
            return new boolean[]{true, true, true, false};
        }

        @Override
        public int compareTo(RootGameTreeRecord rootGameTreeRecord, RootGameTreeRecord rootGameTreeRecord2, int n) {
            switch (n) {
                case 0: {
                    return rootGameTreeRecord.getStatus().compareTo(rootGameTreeRecord2.getStatus());
                }
                case 1: {
                    EnumSet<ProblemType> enumSet = rootGameTreeRecord.getProblemTypes();
                    EnumSet<ProblemType> enumSet2 = rootGameTreeRecord2.getProblemTypes();
                    int n2 = enumSet.size();
                    int n3 = enumSet2.size();
                    if (n2 == 0 && n3 == 0 || n2 != n3) {
                        return n2 - n3;
                    }
                    Iterator iterator = enumSet.iterator();
                    Iterator iterator2 = enumSet2.iterator();
                    while (iterator.hasNext()) {
                        ProblemType problemType;
                        ProblemType problemType2 = (ProblemType)((Object)iterator.next());
                        int n4 = problemType2.compareTo(problemType = (ProblemType)((Object)iterator2.next()));
                        if (n4 == 0) continue;
                        return n4;
                    }
                    return 0;
                }
                case 2: {
                    File file = rootGameTreeRecord.getFileSnapshot().file();
                    File file2 = rootGameTreeRecord2.getFileSnapshot().file();
                    return file.compareTo(file2);
                }
            }
            return 0;
        }

        @Override
        public void set(TableItem tableItem, RootGameTreeRecord rootGameTreeRecord) {
            tableItem.setText(0, String.valueOf((Object)rootGameTreeRecord.getStatus()));
            tableItem.setText(1, rootGameTreeRecord.getProblemTypes().toString());
            String string = Ios.calcRelativePath(ConvertingWizardPage.this.srcRoot_.getAbsolutePath(), rootGameTreeRecord.getFileSnapshot().file().getAbsolutePath());
            tableItem.setText(2, string);
            tableItem.setText(3, String.valueOf(rootGameTreeRecord.getRgtIndex() + 1));
        }

        @Override
        public void setup(TableColumn[] tableColumnArray) {
            tableColumnArray[0].setText(LB_TABLE_STATUS.get());
            tableColumnArray[0].setMoveable(true);
            tableColumnArray[1].setText(LB_TABLE_TYPE.get());
            tableColumnArray[1].setMoveable(true);
            tableColumnArray[2].setText(LB_TABLE_FILE_NAME.get());
            tableColumnArray[2].setMoveable(true);
            tableColumnArray[3].setText(LB_TABLE_INDEX.get());
            tableColumnArray[3].setMoveable(true);
        }
    }

    private class TaskListenerImpl
    implements SimpleTaskListener {
        private TaskListenerImpl() {
        }

        public void setStatus(String string, int n) {
            ConvertingWizardPage.this.progressPanel_.setStatus(string, n);
            ConvertingWizardPage.this.getControl().getDisplay().syncExec(new Runnable(){

                public void run() {
                    ConvertingWizardPage.this.table_.update();
                }
            });
        }

        public void abort(Exception exception) {
            log_s_.error("Error occurred in TaskRunner.", exception);
            ConvertingWizardPage.this.getControl().getDisplay().syncExec(new Runnable(){

                public void run() {
                    ConvertingWizardPage.this.setMessage(MSG_ABORT_WIZARD.get(), 3);
                    ConvertingWizardPage.this.table_.update();
                }
            });
        }

        public void finished() {
            ConvertingWizardPage.this.getControl().getDisplay().syncExec(new Runnable(){

                public void run() {
                    ConvertingWizardPage.this.setMessage(MSG_FINISH_WIZARD.get(), 1);
                    ConvertingWizardPage.this.setPageComplete(true);
                    ConvertingWizardPage.this.table_.update();
                }
            });
        }
    }
}

