/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.wizard.pc;

import java.util.EnumSet;
import org.unitarou.io.FileSnapshot;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.util.pc.ProblemType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.view.jface.wizard.pc.TaskStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RootGameTreeRecord {
    private boolean checked_;
    private final int index_;
    private final FileSnapshot fileSnapshot_;
    private final int rgtIndex_;
    private EnumSet<ProblemType> problemTypes_;
    private TaskStatus status_;

    RootGameTreeRecord(int n, Collection collection, int n2) {
        ArgumentChecker.throwIfNull((Object)collection);
        ArgumentChecker.throwIfNegative(n2);
        this.checked_ = false;
        this.index_ = n;
        this.fileSnapshot_ = new FileSnapshot(collection.getFile());
        this.rgtIndex_ = n2;
        RootGameTree rootGameTree = collection.get(this.rgtIndex_);
        this.problemTypes_ = ProblemType.analyze(rootGameTree);
        this.status_ = TaskStatus.BEFORE;
    }

    RootGameTreeRecord(RootGameTreeRecord rootGameTreeRecord) {
        ArgumentChecker.throwIfNull((Object)rootGameTreeRecord);
        this.checked_ = rootGameTreeRecord.checked_;
        this.index_ = rootGameTreeRecord.index_;
        this.fileSnapshot_ = rootGameTreeRecord.fileSnapshot_;
        this.rgtIndex_ = rootGameTreeRecord.rgtIndex_;
        this.problemTypes_ = rootGameTreeRecord.problemTypes_.clone();
        this.status_ = rootGameTreeRecord.status_;
    }

    void setChecked(boolean bl) {
        this.checked_ = bl;
    }

    void setProblemTypes(EnumSet<ProblemType> enumSet) {
        ArgumentChecker.throwIfNull(enumSet);
        this.problemTypes_ = enumSet;
    }

    void setStatus(TaskStatus taskStatus) {
        ArgumentChecker.throwIfNull((Object)taskStatus);
        this.status_ = taskStatus;
    }

    boolean isChecked() {
        return this.checked_;
    }

    int getIndex() {
        return this.index_;
    }

    FileSnapshot getFileSnapshot() {
        return this.fileSnapshot_;
    }

    int getRgtIndex() {
        return this.rgtIndex_;
    }

    EnumSet<ProblemType> getProblemTypes() {
        return this.problemTypes_;
    }

    TaskStatus getStatus() {
        return this.status_;
    }
}

