/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.wizard.pc;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.unitarou.io.Ios;
import org.unitarou.jface.ColorResource;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.io.SgfIos;
import org.unitarou.sgf.util.pc.ProblemType;
import org.unitarou.swt.FolderPanel;
import org.unitarou.swt.UTable;
import org.unitarou.swt.UTableProvider;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;
import org.unitarou.yukinoshita.view.jface.wizard.pc.RootGameTreeRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceWizardPage
extends WizardPage {
    private static final ContextValue<File> SRC_FOLDER = new ContextValue<File>(SourceWizardPage.class, "srcFolder", Ios.getCurrentDirectory());
    private static final Message MSG_SPECIFY_SOURCE_FOLDER = new Message(SourceWizardPage.class, "msgSpecifySourceFolder");
    private static final Message MSG_CANT_LOAD_FOLDER = new Message(SourceWizardPage.class, "msgCantLoadFolder");
    private static final Message MSG_SPECIFY_FILES = new Message(SourceWizardPage.class, "msgSpecifyFiles");
    private static final Message MSG_SPECIFY_ONE_MORE_PROBLEMS = new Message(SourceWizardPage.class, "msgSpecifyOneMoreProblems");
    private static final Message MSG_PROHIBIT_UNDETECTED = new Message(SourceWizardPage.class, "msgProhibitUndetected");
    private static final Message LB_SRC_FOLDER = new Message(SourceWizardPage.class, "lbSrcFolder");
    private static final Message NT_DLG_SPECIFY_FOLDER = new Message(SourceWizardPage.class, "ntDlgSpecifyFolder");
    private static final Message MSG_DLG_SPECIFY_FOLDER = new Message(SourceWizardPage.class, "msgDlgSpecifyFolder");
    private static final Message LB_TYPE_SELECTOR = new Message(SourceWizardPage.class, "lbTypeSelector");
    private static final Message LB_SRC_COUNT = new Message(SourceWizardPage.class, "lbSrcCount");
    private static final Message NT_LISTING = new Message(SourceWizardPage.class, "ntListing");
    private static final Message NT_TASK_DETECT = new Message(SourceWizardPage.class, "ntTaskDetect");
    private static final Message LB_TABLE_NO = new Message(SourceWizardPage.class, "lbTableNo");
    private static final Message LB_TABLE_TYPE = new Message(SourceWizardPage.class, "lbTableType");
    private static final Message LB_TABLE_FILE_NAME = new Message(SourceWizardPage.class, "lbTableFileName");
    private static final Message LB_TABLE_INDEX = new Message(SourceWizardPage.class, "lbTableIndex");
    private static final ColorResource COL_ITEM_ENABLE = new ColorResource(21);
    private static final ColorResource COL_ITEM_DISABLE = new ColorResource(19);
    private static final EnumSet<ProblemType> TARGET_TYPE = EnumSet.of(ProblemType.GOPROBLEMS, ProblemType.ULIGO, ProblemType.BARIBARI, ProblemType.YUKINOSHITA, ProblemType.NORMAL);
    private final FolderPanel folderPanel_ = new FolderPanel();
    private final UTable<RootGameTreeRecord> table_;
    private final Map<ProblemType, Button> buttonMap_;
    private Label lbRgtSize_;

    protected SourceWizardPage() {
        super("sourceWizardPage");
        this.folderPanel_.setLabelText(LB_SRC_FOLDER.get());
        File file = Yukinoshita.context(null).getAttribute(SRC_FOLDER);
        this.folderPanel_.setup(NT_DLG_SPECIFY_FOLDER.get(), MSG_DLG_SPECIFY_FOLDER.get(), file);
        this.lbRgtSize_ = null;
        this.table_ = new UTable<RootGameTreeRecord>(new LabelProvider(), 65568);
        this.buttonMap_ = new HashMap<ProblemType, Button>();
        this.checkPageComplete();
    }

    private void checkPageComplete() {
        File file = this.folderPanel_.getFolder();
        if (file == null) {
            this.setMessage(MSG_SPECIFY_SOURCE_FOLDER.get(), 1);
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        if (!Ios.isNormalDirectory(file)) {
            this.setMessage(MSG_SPECIFY_SOURCE_FOLDER.get(), 1);
            this.setErrorMessage(MSG_CANT_LOAD_FOLDER.get());
            this.setPageComplete(false);
            return;
        }
        this.setMessage(MSG_SPECIFY_FILES.get());
        boolean bl = false;
        int n = 0;
        for (RootGameTreeRecord rootGameTreeRecord : this.table_.getRecords()) {
            if (!rootGameTreeRecord.isChecked()) continue;
            boolean bl2 = rootGameTreeRecord.getProblemTypes().isEmpty();
            if (!bl2) {
                ++n;
            }
            bl |= bl2;
        }
        this.lbRgtSize_.setText(LB_SRC_COUNT.get((Object)new Integer(n)));
        this.lbRgtSize_.pack();
        if (bl) {
            this.setErrorMessage(MSG_PROHIBIT_UNDETECTED.get());
            this.setPageComplete(false);
            return;
        }
        if (n == 0) {
            this.setErrorMessage(MSG_SPECIFY_ONE_MORE_PROBLEMS.get());
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    @Override
    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(SwtFactory.createInnerGrid(1, false));
        Control control = this.folderPanel_.createContents(composite2);
        control.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.folderPanel_.getText().setEditable(false);
        this.folderPanel_.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                SourceWizardPage.this.changeSourceFolder();
            }
        });
        this.table_.createContents(composite2);
        Table table = this.table_.getControl();
        table.setLinesVisible(true);
        table.setLayoutData(new GridData(4, 4, true, true));
        table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                SourceWizardPage.this.updateTableSelection(event);
            }
        });
        Group group = SwtFactory.createGroup(composite2, 0);
        group.setLayout(SwtFactory.createInnerGrid(5, false));
        group.setLayoutData(new GridData(16384, 128, false, false));
        group.setText(LB_TYPE_SELECTOR.get());
        ButtonListener buttonListener = new ButtonListener();
        for (ProblemType problemType : TARGET_TYPE) {
            Button button = new Button(group, 32);
            button.setText(problemType.toString());
            button.setData((Object)problemType);
            button.setLayoutData(new GridData(16384, 1024, false, false));
            button.addSelectionListener(buttonListener);
            this.buttonMap_.put(problemType, button);
        }
        this.lbRgtSize_ = new Label(composite2, 16384);
        this.lbRgtSize_.setLayoutData(new GridData(1, 1024, false, false));
        this.lbRgtSize_.setText(LB_SRC_COUNT.get((Object)new Integer(0)));
        this.setControl(composite2);
    }

    private void changeSourceFolder() {
        CurrentContext currentContext = Yukinoshita.context(null);
        currentContext.setAttribute(SRC_FOLDER, this.folderPanel_.getStartFolder());
        final File file = this.folderPanel_.getFolder();
        if (file == null || !Ios.isNormalDirectory(file)) {
            this.setErrorMessage(MSG_CANT_LOAD_FOLDER.get());
            this.checkPageComplete();
            return;
        }
        this.setErrorMessage(null);
        final ArrayList arrayList = new ArrayList();
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(null);
        progressMonitorDialog.create();
        progressMonitorDialog.getShell().setText(NT_LISTING.get());
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                iProgressMonitor.beginTask(NT_TASK_DETECT.get(), -1);
                SourceWizardPage.this.loadSgfFiles(arrayList, file, iProgressMonitor);
                iProgressMonitor.done();
            }
        };
        try {
            progressMonitorDialog.run(true, true, iRunnableWithProgress);
            progressMonitorDialog.close();
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        EnumSet<ProblemType> enumSet = EnumSet.noneOf(ProblemType.class);
        for (RootGameTreeRecord object : arrayList) {
            for (ProblemType problemType : object.getProblemTypes()) {
                if (!TARGET_TYPE.contains((Object)problemType)) continue;
                enumSet.add(problemType);
                object.setChecked(true);
            }
        }
        for (ProblemType problemType : EnumSet.allOf(ProblemType.class)) {
            this.buttonMap_.get((Object)problemType).setSelection(enumSet.contains((Object)problemType));
        }
        this.table_.clear();
        this.table_.addAll(arrayList);
        this.checkPageComplete();
    }

    private void loadSgfFiles(List<RootGameTreeRecord> list, File file, IProgressMonitor iProgressMonitor) {
        File[] fileArray;
        File[] fileArray2 = fileArray = file.listFiles(SgfIos.FILEFILTER);
        int n = fileArray2.length;
        for (int i = 0; i < n; ++i) {
            File file2 = fileArray2[i];
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            iProgressMonitor.subTask(file2.getAbsolutePath());
            Collection object = FileManager.instance().openNoDialog(file2, false);
            ArrayList<RootGameTreeRecord> arrayList = new ArrayList<RootGameTreeRecord>(object.size());
            boolean bl = false;
            for (int j = 0; j < object.size(); ++j) {
                RootGameTreeRecord rootGameTreeRecord = new RootGameTreeRecord(list.size() + 1, object, j);
                bl |= rootGameTreeRecord.getProblemTypes().contains((Object)ProblemType.ULIGO);
                arrayList.add(rootGameTreeRecord);
                list.add(rootGameTreeRecord);
            }
            if (!bl) continue;
            for (RootGameTreeRecord rootGameTreeRecord : arrayList) {
                EnumSet<ProblemType> enumSet = rootGameTreeRecord.getProblemTypes();
                enumSet.add(ProblemType.ULIGO);
                enumSet.remove((Object)ProblemType.NORMAL);
                rootGameTreeRecord.setProblemTypes(enumSet);
            }
        }
        for (File file2 : fileArray2 = file.listFiles(SgfIos.DIRFILETER)) {
            this.loadSgfFiles(list, file2, iProgressMonitor);
        }
    }

    private void updateTableSelection(Event event) {
        Table table = this.table_.getControl();
        TableItem tableItem = table.getItem(new Point(event.x, event.y));
        if (tableItem == null) {
            return;
        }
        int n = table.indexOf(tableItem);
        List<RootGameTreeRecord> list = this.table_.getRecords();
        list.get(n).setChecked(tableItem.getChecked());
        this.checkPageComplete();
    }

    public File getSourceRoot() {
        return this.folderPanel_.getFolder();
    }

    public List<RootGameTreeRecord> getRecords() {
        List<RootGameTreeRecord> list = this.table_.getRecords();
        ArrayList<RootGameTreeRecord> arrayList = new ArrayList<RootGameTreeRecord>(list.size());
        for (RootGameTreeRecord rootGameTreeRecord : list) {
            if (!rootGameTreeRecord.isChecked() || rootGameTreeRecord.getProblemTypes().isEmpty()) continue;
            arrayList.add(rootGameTreeRecord);
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LabelProvider
    implements UTableProvider<RootGameTreeRecord> {
        private LabelProvider() {
        }

        @Override
        public int getColumnSize() {
            return 4;
        }

        @Override
        public boolean[] getSotableColums() {
            return new boolean[]{true, true, true, false};
        }

        @Override
        public int compareTo(RootGameTreeRecord rootGameTreeRecord, RootGameTreeRecord rootGameTreeRecord2, int n) {
            switch (n) {
                case 0: {
                    return rootGameTreeRecord.getIndex() - rootGameTreeRecord2.getIndex();
                }
                case 1: {
                    EnumSet<ProblemType> enumSet = rootGameTreeRecord.getProblemTypes();
                    EnumSet<ProblemType> enumSet2 = rootGameTreeRecord2.getProblemTypes();
                    int n2 = enumSet.size();
                    int n3 = enumSet2.size();
                    if (n2 == 0 && n3 == 0 || n2 != n3) {
                        return n2 - n3;
                    }
                    Iterator iterator = enumSet.iterator();
                    Iterator iterator2 = enumSet2.iterator();
                    while (iterator.hasNext()) {
                        ProblemType problemType;
                        ProblemType problemType2 = (ProblemType)((Object)iterator.next());
                        int n4 = problemType2.compareTo(problemType = (ProblemType)((Object)iterator2.next()));
                        if (n4 == 0) continue;
                        return n4;
                    }
                    return 0;
                }
                case 2: {
                    File file = rootGameTreeRecord.getFileSnapshot().file();
                    File file2 = rootGameTreeRecord2.getFileSnapshot().file();
                    return file.compareTo(file2);
                }
            }
            return 0;
        }

        @Override
        public void set(TableItem tableItem, RootGameTreeRecord rootGameTreeRecord) {
            tableItem.setChecked(rootGameTreeRecord.isChecked());
            tableItem.setText(0, String.valueOf(rootGameTreeRecord.getIndex()));
            tableItem.setText(1, rootGameTreeRecord.getProblemTypes().toString());
            String string = Ios.calcRelativePath(SourceWizardPage.this.folderPanel_.getFolder().getAbsolutePath(), rootGameTreeRecord.getFileSnapshot().file().getAbsolutePath());
            tableItem.setText(2, string);
            tableItem.setText(3, String.valueOf(rootGameTreeRecord.getRgtIndex() + 1));
            if (rootGameTreeRecord.getProblemTypes().isEmpty()) {
                tableItem.setForeground(COL_ITEM_DISABLE.get());
            } else {
                tableItem.setForeground(COL_ITEM_ENABLE.get());
            }
        }

        @Override
        public void setup(TableColumn[] tableColumnArray) {
            tableColumnArray[0].setText(LB_TABLE_NO.get());
            tableColumnArray[1].setText(LB_TABLE_TYPE.get());
            tableColumnArray[1].setMoveable(true);
            tableColumnArray[2].setText(LB_TABLE_FILE_NAME.get());
            tableColumnArray[2].setMoveable(true);
            tableColumnArray[3].setText(LB_TABLE_INDEX.get());
            tableColumnArray[3].setMoveable(true);
        }
    }

    private class ButtonListener
    extends SelectionAdapter {
        private ButtonListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Button button = (Button)selectionEvent.widget;
            boolean bl = button.getSelection();
            ProblemType problemType = (ProblemType)((Object)button.getData());
            for (RootGameTreeRecord rootGameTreeRecord : SourceWizardPage.this.table_.getRecords()) {
                if (!rootGameTreeRecord.getProblemTypes().contains((Object)problemType)) continue;
                rootGameTreeRecord.setChecked(bl);
            }
            SourceWizardPage.this.table_.update();
            SourceWizardPage.this.checkPageComplete();
        }
    }
}

