/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.wizard.pc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.unitarou.io.FileSnapshot;
import org.unitarou.io.Ios;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.io.CollectionRepository;
import org.unitarou.sgf.parser.SgfFormatter;
import org.unitarou.sgf.util.filter.UpdateVwFilter;
import org.unitarou.sgf.util.pc.ProblemType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.SimpleTaskListener;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.view.jface.wizard.pc.RootGameTreeRecord;
import org.unitarou.yukinoshita.view.jface.wizard.pc.TaskConfig;
import org.unitarou.yukinoshita.view.jface.wizard.pc.TaskStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskRunner
implements Runnable {
    private static final Message NT_BEFORE_CONVERTING = new Message(TaskRunner.class, "ntBeforeConverting");
    private static final Message NT_CONVERTING = new Message(TaskRunner.class, "ntConverting");
    private static final Message NT_FINISH_CONVERTING = new Message(TaskRunner.class, "ntFinishiConverting");
    private final File srcFolder_;
    private final File desFolder_;
    private final List<RootGameTreeRecord> records_;
    private final EnumSet<TaskConfig> configs_;
    private final boolean removeOtherSetting_;
    private final EnumSet<ProblemType> appendTypes_;
    private final SimpleTaskListener listener_;

    public TaskRunner(File file, File file2, List<RootGameTreeRecord> list, EnumSet<TaskConfig> enumSet, SimpleTaskListener simpleTaskListener) {
        ArgumentChecker.throwIfNull(file, file2, list, enumSet, simpleTaskListener);
        this.srcFolder_ = file;
        this.desFolder_ = file2;
        this.records_ = new ArrayList<RootGameTreeRecord>(list);
        this.configs_ = EnumSet.copyOf(enumSet);
        this.listener_ = simpleTaskListener;
        this.removeOtherSetting_ = enumSet.contains((Object)TaskConfig.REMOVE_OTHER_TYPES);
        this.appendTypes_ = EnumSet.noneOf(ProblemType.class);
        for (TaskConfig taskConfig : EnumSet.allOf(TaskConfig.class)) {
            if (taskConfig.getProblemType() == null || !this.configs_.contains((Object)taskConfig)) continue;
            this.appendTypes_.add(taskConfig.getProblemType());
        }
    }

    @Override
    public void run() {
        try {
            this.listener_.setStatus(NT_BEFORE_CONVERTING.get(), 0);
            Collections.sort(this.records_, new Comparator<RootGameTreeRecord>(){

                @Override
                public int compare(RootGameTreeRecord rootGameTreeRecord, RootGameTreeRecord rootGameTreeRecord2) {
                    int n = rootGameTreeRecord.getFileSnapshot().file().compareTo(rootGameTreeRecord2.getFileSnapshot().file());
                    if (n != 0) {
                        return n;
                    }
                    return rootGameTreeRecord.getRgtIndex() - rootGameTreeRecord2.getRgtIndex();
                }
            });
            File file = null;
            Collection collection = null;
            int n = -1;
            RootGameTreeRecord rootGameTreeRecord = null;
            ArrayList<EnumSet<ProblemType>> arrayList = new ArrayList<EnumSet<ProblemType>>();
            for (int i = 0; i < this.records_.size(); ++i) {
                Object object;
                rootGameTreeRecord = this.records_.get(i);
                FileSnapshot fileSnapshot = rootGameTreeRecord.getFileSnapshot();
                if (!fileSnapshot.file().equals(file)) {
                    object = new FileSnapshot(fileSnapshot.file());
                    if (!((FileSnapshot)object).equals(fileSnapshot)) {
                        rootGameTreeRecord.setStatus(TaskStatus.FAILURE_FILE_UNMATCH_DIGEST);
                        continue;
                    }
                    this.saveFile(file, collection, i, arrayList);
                    file = fileSnapshot.file();
                    collection = FileManager.instance().openNoDialog(file, false);
                }
                object = collection.get(rootGameTreeRecord.getRgtIndex());
                arrayList.add(rootGameTreeRecord.getProblemTypes());
                object = this.convertImpl(rootGameTreeRecord, (RootGameTree)object);
                collection.set((RootGameTree)object, rootGameTreeRecord.getRgtIndex());
                int n2 = i * 100 / this.records_.size();
                if (n == n2) continue;
                n = n2;
                this.listener_.setStatus(NT_CONVERTING.get(file.getAbsolutePath(), new Integer(i), new Integer(this.records_.size())), n);
            }
            this.saveFile(file, collection, this.records_.size(), arrayList);
            this.listener_.setStatus(NT_FINISH_CONVERTING.get(), 100);
            this.listener_.finished();
        }
        catch (Exception exception) {
            this.listener_.abort(exception);
        }
    }

    private RootGameTree convertImpl(RootGameTreeRecord rootGameTreeRecord, RootGameTree rootGameTree) {
        if (rootGameTreeRecord.getProblemTypes().isEmpty()) {
            rootGameTreeRecord.setStatus(TaskStatus.IGNORED);
            return rootGameTree;
        }
        RootGameTree rootGameTree2 = rootGameTree;
        EnumSet<ProblemType> enumSet = rootGameTreeRecord.getProblemTypes();
        for (ProblemType problemType : new ProblemType[]{ProblemType.YUKINOSHITA, ProblemType.GOPROBLEMS, ProblemType.ULIGO, ProblemType.BARIBARI, ProblemType.NORMAL}) {
            if (!enumSet.contains((Object)problemType)) continue;
            problemType.getConverter().tuneForYukinoshita(rootGameTree2);
            break;
        }
        if (this.removeOtherSetting_) {
            for (ProblemType problemType : new ProblemType[]{ProblemType.GOPROBLEMS, ProblemType.ULIGO, ProblemType.BARIBARI, ProblemType.NORMAL}) {
                if (!enumSet.contains((Object)problemType)) continue;
                problemType.getConverter().removeConfig(rootGameTree2);
            }
        } else {
            for (ProblemType problemType : new ProblemType[]{ProblemType.GOPROBLEMS, ProblemType.ULIGO, ProblemType.BARIBARI, ProblemType.NORMAL}) {
                if (!this.appendTypes_.contains((Object)problemType) || enumSet.contains((Object)problemType) || !problemType.isAppendable(rootGameTreeRecord.getProblemTypes())) continue;
                problemType.getConverter().appendConfig(rootGameTree2);
            }
        }
        if (this.configs_.contains((Object)TaskConfig.APPEND_VW)) {
            UpdateVwFilter updateVwFilter = new UpdateVwFilter(UpdateVwFilter.Config.STANDARD);
            rootGameTree2 = updateVwFilter.filter(rootGameTree2);
        }
        rootGameTreeRecord.setProblemTypes(ProblemType.analyze(rootGameTree2));
        return rootGameTree2;
    }

    private void saveFile(File file, Collection collection, int n, List<EnumSet<ProblemType>> list) {
        int n2;
        if (file == null) {
            return;
        }
        TaskStatus taskStatus = this.saveFileImpl(file, collection);
        int n3 = 0;
        boolean bl = false;
        for (n2 = n - list.size(); n2 < n; ++n2) {
            RootGameTreeRecord rootGameTreeRecord = this.records_.get(n2);
            rootGameTreeRecord.setStatus(taskStatus);
            if (taskStatus.isFailure()) {
                rootGameTreeRecord.setProblemTypes(list.get(n3));
            }
            bl |= rootGameTreeRecord.getProblemTypes().contains((Object)ProblemType.ULIGO);
            ++n3;
        }
        if (bl) {
            for (n2 = n - list.size(); n2 < n; ++n2) {
                this.records_.get(n2).getProblemTypes().add(ProblemType.ULIGO);
            }
        }
        list.clear();
    }

    private TaskStatus saveFileImpl(File file, Collection collection) {
        String string = Ios.calcRelativePath(this.srcFolder_.getAbsolutePath(), file.getAbsolutePath());
        String string2 = this.desFolder_.getAbsolutePath();
        File file2 = new File(FilenameUtils.concat(string2, string));
        File file3 = new File(FilenameUtils.getFullPathNoEndSeparator(file2.getAbsolutePath()));
        if (!file3.exists() && !file3.mkdirs()) {
            return TaskStatus.FAILURE_FILE_IO;
        }
        if (file2.exists() && !this.configs_.contains((Object)TaskConfig.OVERWRITABLE)) {
            return TaskStatus.FAILURE_FILE_CANT_OVERWRITE;
        }
        try {
            SgfFormatter sgfFormatter = new SgfFormatter();
            EnumSet<SgfFormatter.Option> enumSet = sgfFormatter.getOptions();
            enumSet.add(SgfFormatter.Option.ADD_NEW_LINE_BEFORE_RGT);
            enumSet.add(SgfFormatter.Option.USE_TT_PASS);
            sgfFormatter.setOptions(enumSet);
            sgfFormatter.setComposeOption(SgfFormatter.ComposeOption.EXPAND);
            CollectionRepository.instance().save(collection, file2, sgfFormatter);
            return TaskStatus.CONVERTED;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return TaskStatus.FAILURE_FILE_IO;
        }
    }
}

