/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.provider.blklp;

import java.util.Set;
import java.util.TreeSet;
import org.unitarou.ml.Message;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.jface.board.BlockPainter;
import org.unitarou.yukinoshita.view.provider.blklp.BlockLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoneLifePointProvider
implements BlockLabelProvider {
    private static final Message LB_DISPLAY_NAME = new Message(StoneLifePointProvider.class, "lbDisplayName");

    @Override
    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }

    @Override
    public String getLabel(NodeView nodeView, SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)sgfPoint);
        int n = nodeView.getIgoBoard().lifePoint(sgfPoint);
        return 0 < n ? Integer.toString(n) : "";
    }

    @Override
    public Set<SgfPoint> getDurablePaintings(NodeView nodeView) {
        return BlockPainter.EMPTY_SET;
    }

    @Override
    public Set<SgfPoint> getTransientPaintings(NodeView nodeView) {
        ArgumentChecker.throwIfNull((Object)nodeView);
        TreeSet<SgfPoint> treeSet = new TreeSet<SgfPoint>();
        treeSet.addAll(nodeView.getIgoBoard().position(SgfColor.BLACK));
        treeSet.addAll(nodeView.getIgoBoard().position(SgfColor.WHITE));
        return treeSet;
    }
}

