/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.provider.nlp;

import org.unitarou.ml.Message;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.provider.nlp.BasicLabel;
import org.unitarou.yukinoshita.view.provider.nlp.GwGbLabel;
import org.unitarou.yukinoshita.view.provider.nlp.NodeViewLabel;
import org.unitarou.yukinoshita.view.provider.nlp.NodeViewLabelProvider;
import org.unitarou.yukinoshita.view.provider.nlp.PropertyTypeLabel;

public class Ver1NodeLabelProvider
implements NodeViewLabelProvider {
    private static final NodeViewLabel[] nodeViewLabels_s_ = new NodeViewLabel[]{new PropertyTypeLabel(PropertyType.ROOT), new PropertyTypeLabel(PropertyType.GAME_INFO), new PropertyTypeLabel(PropertyType.SETUP), new BasicLabel(SgfId.PLAYER_TO_PLAY), new BasicLabel(SgfId.NODENAME), new BasicLabel(SgfId.COMMENT), new BasicLabel(SgfId.DOUBTFUL), new BasicLabel(SgfId.INTERESTING), new BasicLabel(SgfId.TESUJI), new BasicLabel(SgfId.BAD_MOVE), new GwGbLabel(SgfId.GOOD_FOR_WHITE), new GwGbLabel(SgfId.GOOD_FOR_BLACK), new BasicLabel(SgfId.EVEN_POSITION), new BasicLabel(SgfId.UNCLEAR_POS), new BasicLabel(SgfId.HOTSPOT)};
    private static final Message LB_DISPLAY_NAME = new Message(Ver1NodeLabelProvider.class, "lbDisplayName");

    public String getLabel(NodeView nodeView) {
        ArgumentChecker.throwIfNull((Object)nodeView);
        GameType gameType = nodeView.getRootView().getGameType();
        StringBuilder stringBuilder = new StringBuilder();
        for (NodeViewLabel nodeViewLabel : nodeViewLabels_s_) {
            String string = nodeViewLabel.getLabel(gameType, nodeView);
            if (string.length() != 0) {
                string = string + ' ';
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }
}

