/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.jface.dialogs.ControlAnimator;
import org.eclipse.jface.dialogs.DialogMessageArea;
import org.eclipse.jface.dialogs.ImageAndMessageArea;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;

class PreferenceMessageArea
extends DialogMessageArea {
    private String lastMessageText;
    private int lastMessageType;
    private CLabel titleLabel;
    private ImageAndMessageArea messageArea;
    private PreferenceDialog preferenceDialog;
    private static int titleLabelOffset = -1;
    private ControlAnimator animator;

    public PreferenceMessageArea(PreferenceDialog preferenceDialog) {
        this.preferenceDialog = preferenceDialog;
    }

    public void createContents(Composite parent) {
        this.titleLabel = new CLabel(parent, 0);
        this.titleLabel.setFont(JFaceResources.getBannerFont());
        this.messageArea = new ImageAndMessageArea(this.preferenceDialog.formTitleComposite, 64);
        this.messageArea.setFont(JFaceResources.getDialogFont());
        this.messageArea.setVisible(false);
        this.animator = Policy.getAnimatorFactory().createAnimator(this.messageArea);
    }

    public void setMessageLayoutData(Object layoutData) {
        ((FormData)layoutData).top = null;
        ((FormData)layoutData).right = new FormAttachment(100, -this.getTitleLabelOffset());
        this.messageArea.setLayoutData(layoutData);
    }

    private int getTitleLabelOffset() {
        if (titleLabelOffset == -1) {
            int offsetCalc = this.preferenceDialog.formTitleComposite.getBounds().width - this.titleLabel.getBounds().width;
            if (offsetCalc > 0) {
                titleLabelOffset = offsetCalc;
                return titleLabelOffset;
            }
            return 0;
        }
        return titleLabelOffset;
    }

    public void updateText(String newMessage, int newType) {
        Image newImage = null;
        switch (newType) {
            case 0: {
                if (newMessage == null) {
                    this.restoreTitle();
                } else {
                    this.showTitle(newMessage, null);
                }
                return;
            }
            case 1: {
                newImage = JFaceResources.getImage("dialog_messasge_info_image");
                break;
            }
            case 2: {
                newImage = JFaceResources.getImage("dialog_messasge_warning_image");
                break;
            }
            case 3: {
                newImage = JFaceResources.getImage("dialog_message_error_image");
            }
        }
        this.messageArea.moveAbove(null);
        this.messageArea.setImage(newImage);
        this.messageArea.setText(newMessage);
        this.messageArea.setToolTipText(newMessage);
        this.lastMessageText = newMessage;
        int bottom = this.messageArea.getParent().getBounds().height;
        if (!this.messageArea.isVisible() && this.messageArea.getBounds().y != bottom) {
            this.messageArea.setBounds(this.messageArea.getBounds().x, bottom, this.titleLabel.getBounds().width, this.messageArea.computeSize((int)-1, (int)-1).y);
        }
        this.animator.setVisible(true);
        this.setMessageLayoutData(this.messageArea.getLayoutData());
    }

    public void restoreTitle() {
        this.titleLabel.setVisible(true);
        this.animator.setVisible(false);
        this.lastMessageText = null;
        this.lastMessageType = 0;
    }

    public void clearErrorMessage() {
        if (this.lastMessageText == null) {
            this.restoreTitle();
        } else {
            this.updateText(this.lastMessageText, this.lastMessageType);
        }
    }

    public void setTitleLayoutData(Object layoutData) {
        this.titleLabel.setLayoutData(layoutData);
    }

    public void showTitle(String titleMessage, Image titleImage) {
        this.titleLabel.setImage(titleImage);
        this.titleLabel.setText(titleMessage);
        this.restoreTitle();
    }
}

