/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.io;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.io.Ios;
import org.unitarou.lang.ArgumentChecker;

public class FileSnapshot {
    private static final Log log_s_ = LogFactory.getLog(FileSnapshot.class);
    private final File file_;
    private final long lastModified_;
    private final long length_;
    private final byte[] digest_;

    public FileSnapshot(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        this.file_ = file;
        this.lastModified_ = this.file_.lastModified();
        this.length_ = this.file_.length();
        byte[] byArray = null;
        try {
            byArray = Ios.calcMD5(this.file_);
        }
        catch (IOException iOException) {
            log_s_.warn(iOException.getLocalizedMessage(), iOException);
            byArray = new byte[]{};
        }
        this.digest_ = byArray;
    }

    public File file() {
        return this.file_;
    }

    public long lastModified() {
        return this.lastModified_;
    }

    public long length() {
        return this.length_;
    }

    public byte[] getDigest() {
        byte[] byArray = new byte[this.digest_.length];
        System.arraycopy(this.digest_, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        FileSnapshot fileSnapshot = (FileSnapshot)object;
        return this.lastModified_ == fileSnapshot.lastModified_ && this.length_ == fileSnapshot.length_ && FilenameUtils.equalsOnSystem(this.file_.getAbsolutePath(), fileSnapshot.file_.getAbsolutePath()) && Arrays.equals(this.digest_, fileSnapshot.digest_);
    }

    public int hashCode() {
        String string = this.file_.getAbsolutePath();
        if (File.separatorChar == '\\') {
            string = string.toUpperCase();
        }
        return (int)((long)(string.hashCode() * 1009) + this.lastModified_ * 1013L + this.length_ * 1019L);
    }
}

