/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.unitarou.lang.ArgumentChecker;

public class FontResource {
    private static final FontRegistry fontRegistry_s_ = JFaceResources.getFontRegistry();
    private static final char DELIMITER = '_';
    private static final FontData DEFAULT = new FontData();
    private final String fontName_;
    private final int defaultHeight_;
    private final int defaultStyle_;
    private final String defaultKey_;

    public FontResource(int n, int n2) {
        this(DEFAULT.getName(), n, n2);
    }

    public FontResource(String string, int n, int n2) {
        ArgumentChecker.throwIfNull((Object)string);
        this.fontName_ = string;
        this.defaultHeight_ = n;
        this.defaultStyle_ = n2;
        this.defaultKey_ = this.makeKey(this.fontName_, this.defaultHeight_, this.defaultStyle_);
        if (!fontRegistry_s_.hasValueFor(this.defaultKey_)) {
            fontRegistry_s_.put(this.defaultKey_, new FontData[]{new FontData(this.fontName_, this.defaultHeight_, this.defaultStyle_)});
        }
    }

    private String makeKey(String string, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 40);
        stringBuilder.append(this.getClass().getName()).append('_');
        stringBuilder.append(string).append('_');
        stringBuilder.append(n).append('_');
        if (n2 == 0) {
            stringBuilder.append('N');
        } else {
            if (0 != (n2 & 1)) {
                stringBuilder.append('B');
            }
            if (0 != (n2 & 2)) {
                stringBuilder.append('I');
            }
        }
        return stringBuilder.toString();
    }

    public Font get() {
        return fontRegistry_s_.get(this.defaultKey_);
    }

    public Font get(int n) {
        if (n == this.defaultHeight_) {
            return this.get();
        }
        if (n <= 0) {
            return this.get();
        }
        String string = this.makeKey(this.fontName_, n, this.defaultStyle_);
        if (!fontRegistry_s_.hasValueFor(string)) {
            fontRegistry_s_.put(string, new FontData[]{new FontData(this.fontName_, n, this.defaultStyle_)});
        }
        Font font = fontRegistry_s_.get(string);
        return font;
    }

    public Font getInCircle(GC gC, String string, int n) {
        ArgumentChecker.throwIfNull((Object)gC, (Object)string);
        gC.setFont(this.get());
        int n2 = gC.getFont().getFontData()[0].getHeight();
        Point point = gC.textExtent(string);
        double d = Math.sqrt(point.x * point.x + point.y * point.y);
        int n3 = (int)((double)n2 * (double)n / d);
        if (n3 <= 0) {
            n3 = 1;
        }
        return this.get(n3);
    }

    public Font getInRect(GC gC, String string, Point point) {
        ArgumentChecker.throwIfNull((Object)gC, (Object)string);
        gC.setFont(this.get());
        int n = gC.getFont().getFontData()[0].getHeight();
        Point point2 = gC.textExtent(string);
        double d = Math.min((double)point.x / (double)point2.x, (double)point.y / (double)point2.y);
        int n2 = (int)((double)n * d);
        if (n2 <= 0) {
            n2 = 1;
        }
        return this.get(n2);
    }
}

