/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface.pref;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.jface.pref.BooleanCodec;
import org.unitarou.jface.pref.CharsetArrayCodec;
import org.unitarou.jface.pref.EnumCodec;
import org.unitarou.jface.pref.EnumSetCodec;
import org.unitarou.jface.pref.FileArrayCodec;
import org.unitarou.jface.pref.FileCodec;
import org.unitarou.jface.pref.IntArrayCodec;
import org.unitarou.jface.pref.IntegerCodec;
import org.unitarou.jface.pref.PreferenceCodec;
import org.unitarou.jface.pref.ProviderCodec;
import org.unitarou.jface.pref.RgbCodec;
import org.unitarou.lang.ArgumentChecker;

public final class CodecServer {
    private static final Log log_s_ = LogFactory.getLog(CodecServer.class);
    private static final CodecServer instance_s_ = new CodecServer();
    public static final char SEPARATOR = '@';
    private final Map<Class<? extends PreferenceCodec>, PreferenceCodec> codecMap_ = new LinkedHashMap<Class<? extends PreferenceCodec>, PreferenceCodec>();

    public static CodecServer instance() {
        return instance_s_;
    }

    private CodecServer() {
        this.codecMap_.put(BooleanCodec.class, BooleanCodec.instance());
        this.codecMap_.put(IntegerCodec.class, IntegerCodec.instance());
        this.codecMap_.put(IntArrayCodec.class, IntArrayCodec.instance());
        this.codecMap_.put(EnumCodec.class, EnumCodec.instance());
        this.codecMap_.put(ProviderCodec.class, ProviderCodec.instance());
        this.codecMap_.put(FileCodec.class, FileCodec.instance());
        this.codecMap_.put(FileArrayCodec.class, FileArrayCodec.instance());
        this.codecMap_.put(CharsetArrayCodec.class, CharsetArrayCodec.instance());
        this.codecMap_.put(RgbCodec.class, RgbCodec.instance());
        this.codecMap_.put(EnumSetCodec.class, EnumSetCodec.instance());
    }

    public boolean isEncodable(Object object) {
        for (PreferenceCodec preferenceCodec : this.codecMap_.values()) {
            if (!preferenceCodec.isEncodable(object)) continue;
            return true;
        }
        return false;
    }

    public Object decode(Object object, String string) {
        ArgumentChecker.throwIfNull(object, (Object)string);
        for (PreferenceCodec preferenceCodec : this.codecMap_.values()) {
            if (!preferenceCodec.isEncodable(object)) continue;
            return preferenceCodec.decode(string);
        }
        return null;
    }

    public Object decode(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        int n = string.indexOf(64);
        if (n == -1) {
            log_s_.debug("[IGNORE] Unknown type value: " + string);
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = ++n < string.length() ? string.substring(n) : "";
        try {
            Class<?> clazz = Class.forName(string2);
            PreferenceCodec preferenceCodec = this.codecMap_.get(clazz);
            if (preferenceCodec == null) {
                preferenceCodec = (PreferenceCodec)clazz.newInstance();
            }
            return preferenceCodec.decode(string3);
        }
        catch (Exception exception) {
            log_s_.warn("[IGNORE] " + string + '@' + exception.getLocalizedMessage());
            return null;
        }
    }

    public String encode(Object object) {
        ArgumentChecker.throwIfNull(object);
        for (PreferenceCodec preferenceCodec : this.codecMap_.values()) {
            if (object == null) {
                log_s_.warn("[BUG] EMPTY CODEC");
                continue;
            }
            if (!preferenceCodec.isEncodable(object)) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(preferenceCodec.getClass().getName()).append('@').append(preferenceCodec.encode(object));
            return stringBuilder.toString();
        }
        return null;
    }

    public String encodeNoCodec(Object object) {
        ArgumentChecker.throwIfNull(object);
        for (PreferenceCodec preferenceCodec : this.codecMap_.values()) {
            if (object == null) {
                log_s_.warn("[BUG] EMPTY CODEC");
                continue;
            }
            if (!preferenceCodec.isEncodable(object)) continue;
            String string = preferenceCodec.encode(object);
            if (preferenceCodec instanceof EnumCodec) {
                string = string.substring(string.indexOf(64) + 1);
            }
            return string;
        }
        return null;
    }
}

