/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface.pref;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.jface.pref.PreferenceCodec;
import org.unitarou.lang.ArgumentChecker;

public class EnumSetCodec
implements PreferenceCodec {
    private static final Log log_s_ = LogFactory.getLog(EnumSetCodec.class);
    private static final String DELIMITER = ",";
    private static final EnumSetCodec instance_s_ = new EnumSetCodec();

    public static EnumSetCodec instance() {
        return instance_s_;
    }

    private EnumSetCodec() {
    }

    public boolean isEncodable(Object object) {
        return object instanceof EnumSet;
    }

    public String encode(Object object) {
        ArgumentChecker.throwIfNull(object);
        if (!this.isEncodable(object)) {
            throw new IllegalArgumentException();
        }
        return this.encode((EnumSet)object);
    }

    public String encode(EnumSet enumSet) {
        EnumSet enumSet2;
        ArgumentChecker.throwIfNull((Object)enumSet);
        EnumSet enumSet3 = enumSet2 = enumSet.isEmpty() ? EnumSet.complementOf(enumSet) : enumSet;
        if (enumSet2.isEmpty()) {
            return "";
        }
        Enum enum_ = (Enum)enumSet2.iterator().next();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(enum_.getDeclaringClass().getName()).append('@');
        for (Object e : enumSet) {
            stringBuilder.append(((Enum)e).name()).append(DELIMITER);
        }
        if (!enumSet.isEmpty()) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public Object decode(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        int n = string.indexOf(64);
        if (n == -1) {
            log_s_.warn("[IGNORE] Unknown type value: " + string);
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = ++n < string.length() ? string.substring(n) : "";
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, DELIMITER);
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        try {
            Class<?> clazz = Class.forName(string2);
            Enum[] enumArray = (Enum[])clazz.getEnumConstants();
            if (enumArray == null) {
                log_s_.warn("[IGNORE] Unknown type value: " + string);
                return null;
            }
            ArrayList<Enum> arrayList = new ArrayList<Enum>();
            for (Enum enum_ : enumArray) {
                if (!hashSet.contains(enum_.name())) continue;
                arrayList.add(enum_);
            }
            return EnumSet.copyOf(arrayList);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log_s_.warn("[IGNORE] " + string + '@' + classNotFoundException.getLocalizedMessage());
            return null;
        }
    }
}

