/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface.pref;

import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.unitarou.jface.pref.EnumSetCodec;
import org.unitarou.lang.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumSetGroupFieldEditor<E extends Enum<E>>
extends FieldEditor {
    private EnumSet<E> enumSet_;
    private String value_;
    private Group frame_;
    private final Map<E, Button> buttonMap_;
    private final SelectionListener buttonListener_;

    public EnumSetGroupFieldEditor(String string, String string2, Composite composite, EnumSet<E> enumSet) {
        ArgumentChecker.throwIfNull((Object)string, (Object)string2, (Object)composite, enumSet);
        this.enumSet_ = enumSet.clone();
        this.frame_ = null;
        this.buttonMap_ = new HashMap<E, Button>();
        this.buttonListener_ = new ButtonListener();
        this.init(string, string2);
        this.createControl(composite);
    }

    @Override
    protected void adjustForNumColumns(int n) {
        Label label = this.getLabelControl();
        if (label != null) {
            ((GridData)label.getLayoutData()).horizontalSpan = n;
        }
        ((GridData)this.frame_.getLayoutData()).horizontalSpan = n;
    }

    @Override
    protected void doFillIntoGrid(Composite composite, int n) {
        if (this.frame_ != null) {
            return;
        }
        this.frame_ = new Group(composite, 16);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = n;
        this.frame_.setLayoutData(gridData);
        this.frame_.setText(this.getLabelText());
        this.frame_.setLayout(new FillLayout(512));
        for (Enum enum_ : this.enumSet_) {
            Button button = new Button(this.frame_, 32);
            button.setText(enum_.toString());
            button.setData(enum_);
            button.addSelectionListener(this.buttonListener_);
            this.buttonMap_.put(enum_, button);
        }
    }

    @Override
    protected void doLoad() {
        this.updateValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    @Override
    protected void doLoadDefault() {
        this.updateValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    @Override
    protected void doStore() {
        if (this.value_ == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.value_);
    }

    private void updateValue(String string) {
        this.value_ = string;
        if (this.value_ == null) {
            this.value_ = "";
        }
        EnumSet enumSet = (EnumSet)EnumSetCodec.instance().decode(string);
        for (Map.Entry<E, Button> entry : this.buttonMap_.entrySet()) {
            entry.getValue().setSelection(enumSet.contains(entry.getKey()));
        }
    }

    @Override
    public int getNumberOfControls() {
        return 1;
    }

    private class ButtonListener
    extends SelectionAdapter {
        private ButtonListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Object object = EnumSetGroupFieldEditor.this.enumSet_.clone();
            ((AbstractCollection)object).clear();
            for (Map.Entry entry : EnumSetGroupFieldEditor.this.buttonMap_.entrySet()) {
                if (!((Button)entry.getValue()).getSelection()) continue;
                ((AbstractCollection)object).add(entry.getKey());
            }
            EnumSetGroupFieldEditor.this.value_ = EnumSetCodec.instance().encode((EnumSet)object);
        }
    }
}

