/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface.pref;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.jface.pref.PreferenceCodec;
import org.unitarou.lang.ArgumentChecker;

public final class IntArrayCodec
implements PreferenceCodec {
    private static final Log log_s_ = LogFactory.getLog(IntArrayCodec.class);
    private static String DELIMITER_ARRAY = ",";
    private static final IntArrayCodec instance_s_ = new IntArrayCodec();

    public static IntArrayCodec instance() {
        return instance_s_;
    }

    private IntArrayCodec() {
    }

    public boolean isEncodable(Object object) {
        return object instanceof int[];
    }

    public String encode(Object object) {
        ArgumentChecker.throwIfNull(object);
        if (!this.isEncodable(object)) {
            throw new IllegalArgumentException();
        }
        return this.encode((int[])object);
    }

    public String encode(int[] nArray) {
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : nArray) {
            stringBuilder.append(n).append(DELIMITER_ARRAY);
        }
        stringBuilder.delete(stringBuilder.length() - DELIMITER_ARRAY.length(), stringBuilder.length());
        return stringBuilder.toString();
    }

    public int[] decode(String string) {
        Object object;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER_ARRAY);
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            try {
                Integer n = Integer.decode(((String)object).trim());
                arrayList.add(n);
            }
            catch (NumberFormatException numberFormatException) {
                log_s_.warn("Bad value: " + (String)object, numberFormatException);
            }
        }
        object = new int[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Integer)arrayList.get(i);
        }
        return object;
    }
}

